/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.runtime.tools.quarkus.extension.runtime.user;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.ConfigProvider;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.user.User;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.user.UserInfo;

public class UserInfoSupplier
implements Supplier<UserInfo> {
    @Override
    public UserInfo get() {
        Optional userNames = ConfigProvider.getConfig().getOptionalValue("quarkus.kogito-runtime-tools.users", String[].class);
        if (!userNames.isPresent()) {
            return new UserInfo(Collections.emptyList());
        }
        ArrayList<User> users = new ArrayList<User>();
        for (String userName : (String[])userNames.get()) {
            Optional groups = ConfigProvider.getConfig().getOptionalValue("quarkus.kogito-runtime-tools.users." + userName + ".groups", String[].class);
            users.add(new User(userName, Arrays.asList(groups.orElse(new String[0]))));
        }
        return new UserInfo(users);
    }
}

