/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.runtime.tools.quarkus.extension.runtime.forms.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.forms.FormsStorage;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.forms.impl.FormsStorageImpl;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.forms.model.Form;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.forms.model.FormFilter;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class FormsStorageImplTest {
    FormsStorage formsStorage;
    private static String FORM_NAME = "hiring_HRInterview";
    private static String FORM_NAME_WITH_OUT_CONDIF = "hiring_HRInterviewWithoutConfig";

    @BeforeAll
    public void init() {
        URL formsFolder = Thread.currentThread().getContextClassLoader().getResource("forms");
        this.formsStorage = new FormsStorageImpl();
        ((FormsStorageImpl)this.formsStorage).initForTestCase(formsFolder);
    }

    @Test
    public void testGetFormsCount() {
        Assertions.assertEquals((int)2, (int)this.formsStorage.getFormsCount());
    }

    @Test
    public void testGetFormInfoList() {
        Collection formInfosAll = this.formsStorage.getFormInfoList(null);
        Assertions.assertEquals((int)2, (int)formInfosAll.size());
        FormFilter filterEmpty = new FormFilter();
        filterEmpty.setNames(Collections.emptyList());
        Collection formInfosAllEmptyFilter = this.formsStorage.getFormInfoList(filterEmpty);
        Assertions.assertEquals((int)2, (int)formInfosAll.size());
        FormFilter filter = new FormFilter();
        filter.setNames(Arrays.asList(FORM_NAME));
        Collection formInfos = this.formsStorage.getFormInfoList(filter);
        Assertions.assertEquals((int)1, (int)formInfos.size());
    }

    @Test
    public void testGetFormContent() throws IOException {
        Form formContent = this.formsStorage.getFormContent(FORM_NAME);
        Assertions.assertNotNull((Object)formContent);
        Assertions.assertEquals((Object)FORM_NAME, (Object)formContent.getName());
    }

    @Test
    public void testGetFormContentWithoutConfig() {
        Assertions.assertThrows(FileNotFoundException.class, () -> this.formsStorage.getFormContent(FORM_NAME_WITH_OUT_CONDIF));
        Assertions.assertThrows(FileNotFoundException.class, () -> this.formsStorage.getFormContent("ERROR"));
    }
}

