/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.runtime.tools.quarkus.extension.runtime.dataindex;

import io.quarkus.arc.Arc;
import java.lang.annotation.Annotation;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import javax.json.bind.adapter.JsonbAdapter;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.dataindex.DataIndexClient;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.dataindex.jobs.JobsInstancesAdapter;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.dataindex.jobs.JobsResponse;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.dataindex.processes.ProcessInstancesAdapter;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.dataindex.processes.ProcessInstancesResponse;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.dataindex.tasks.TasksResponse;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.dataindex.tasks.UserTaskInstancesAdapter;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.forms.FormsStorage;

@Path(value="/dataindex")
public class DataIndexService {
    public static final String ALL_TASKS_IDS_QUERY = "{ \"operationName\": \"getAllTasksIds\", \"query\": \"query getAllTasksIds{  UserTaskInstances{ id } }\" }";
    public static final String ALL_PROCESS_INSTANCES_IDS_QUERY = "{ \"operationName\": \"getAllProcessesIds\", \"query\": \"query getAllProcessesIds{  ProcessInstances{ id } }\" }";
    public static final String ALL_JOBS_IDS_QUERY = "{ \"operationName\": \"getAllJobsIds\", \"query\": \"query getAllJobsIds{  Jobs{ id } }\" }";

    @GET
    @Path(value="/tasks/count")
    @Produces(value={"text/plain"})
    public Response tasksCount() {
        Response response;
        block8: {
            Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withAdapters(new JsonbAdapter[]{new UserTaskInstancesAdapter()}));
            try {
                String tasksQueryResponse = this.getDataIndexClient().query(ALL_TASKS_IDS_QUERY);
                TasksResponse tasksResponse = (TasksResponse)jsonb.fromJson(tasksQueryResponse, TasksResponse.class);
                int tasksCount = tasksResponse.getData().getUserTaskInstances().size();
                response = Response.ok((Object)tasksCount).build();
                if (jsonb == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonb != null) {
                        try {
                            jsonb.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return Response.serverError().build();
                }
            }
            jsonb.close();
        }
        return response;
    }

    @GET
    @Path(value="/processInstances/count")
    @Produces(value={"text/plain"})
    public Response processInstancesCount() {
        Response response;
        block8: {
            Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withAdapters(new JsonbAdapter[]{new ProcessInstancesAdapter()}));
            try {
                String processInstancesQueryResponse = this.getDataIndexClient().query(ALL_PROCESS_INSTANCES_IDS_QUERY);
                ProcessInstancesResponse processInstancesResponse = (ProcessInstancesResponse)jsonb.fromJson(processInstancesQueryResponse, ProcessInstancesResponse.class);
                int processInstancesCount = processInstancesResponse.getData().getProcessInstances().size();
                response = Response.ok((Object)processInstancesCount).build();
                if (jsonb == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonb != null) {
                        try {
                            jsonb.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return Response.serverError().build();
                }
            }
            jsonb.close();
        }
        return response;
    }

    @GET
    @Path(value="/jobs/count")
    @Produces(value={"text/plain"})
    public Response jobsCount() {
        Response response;
        block8: {
            Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withAdapters(new JsonbAdapter[]{new JobsInstancesAdapter()}));
            try {
                String jobsQueryResponse = this.getDataIndexClient().query(ALL_JOBS_IDS_QUERY);
                JobsResponse jobsResponse = (JobsResponse)jsonb.fromJson(jobsQueryResponse, JobsResponse.class);
                int jobsCount = jobsResponse.getData().getJobs().size();
                response = Response.ok((Object)jobsCount).build();
                if (jsonb == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonb != null) {
                        try {
                            jsonb.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return Response.serverError().build();
                }
            }
            jsonb.close();
        }
        return response;
    }

    @GET
    @Path(value="/forms/count")
    @Produces(value={"text/plain"})
    public Response formsCount() {
        try {
            int formsCount = this.getFormsStorage().getFormsCount();
            return Response.ok((Object)formsCount).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    private DataIndexClient getDataIndexClient() {
        return (DataIndexClient)Arc.container().instance(DataIndexClient.class, new Annotation[]{RestClient.LITERAL}).get();
    }

    private FormsStorage getFormsStorage() {
        return (FormsStorage)Arc.container().instance(FormsStorage.class, new Annotation[0]).get();
    }
}

