/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.runtime.tools.quarkus.extension.runtime.forms;

import java.io.FileNotFoundException;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.forms.FormsStorage;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.forms.model.FormFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/forms")
public class FormsService {
    private FormsStorage storage;
    private static final Logger LOGGER = LoggerFactory.getLogger(FormsService.class);

    @Inject
    public FormsService(FormsStorage storage) {
        this.storage = storage;
    }

    @GET
    @Path(value="/list")
    @Produces(value={"application/json"})
    public Response getFormsList(@QueryParam(value="names") FormFilter filter) {
        try {
            return Response.ok(this.storage.getFormInfoList(filter)).build();
        }
        catch (Exception e) {
            LOGGER.error("Error while getting forms list: ", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/count")
    @Produces(value={"text/plain"})
    public Response formsCount() {
        try {
            return Response.ok((Object)this.storage.getFormsCount()).build();
        }
        catch (Exception e) {
            LOGGER.error("Error while getting forms count: ", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/formName/{formName:\\S+}/")
    @Produces(value={"application/json"})
    public Response getFormContent(@PathParam(value="formName") String formName) {
        try {
            Response.ResponseBuilder responseBuilder = Response.ok((Object)this.storage.getFormContent(formName).toString());
            return responseBuilder.build();
        }
        catch (FileNotFoundException fe) {
            return Response.status((int)Response.Status.NOT_FOUND.getStatusCode(), (String)fe.getMessage()).build();
        }
        catch (Exception e) {
            LOGGER.error("Error while getting form content: ", (Throwable)e);
            return Response.serverError().build();
        }
    }
}

