/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.runtime.tools.quarkus.extension.runtime.forms.impl;

import io.vertx.core.json.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.forms.FormsStorage;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.forms.model.Form;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.forms.model.FormConfiguration;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.forms.model.FormFilter;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.forms.model.FormInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class FormsStorageImpl
implements FormsStorage {
    private static final String FORMS_STORAGE_PATH = "/forms";
    private static final Logger LOGGER = LoggerFactory.getLogger(FormsStorageImpl.class);
    private URL formsFolder;
    private Map<String, FormInfo> formInfoMap = new HashMap<String, FormInfo>();

    @PostConstruct
    public void init() {
        this.formsFolder = Thread.currentThread().getContextClassLoader().getResource(FORMS_STORAGE_PATH);
        this.reloadFormBaseInfoList();
    }

    protected void initForTestCase(URL formsFolder) {
        this.formsFolder = formsFolder;
        this.reloadFormBaseInfoList();
    }

    @Override
    public int getFormsCount() {
        return this.formInfoMap.keySet().size();
    }

    @Override
    public Collection<FormInfo> getFormInfoList(FormFilter filter) {
        if (filter != null && filter.getNames().size() > 0) {
            return this.formInfoMap.entrySet().stream().filter(entry -> StringUtils.containsAnyIgnoreCase((CharSequence)((CharSequence)entry.getKey()), (CharSequence[])filter.getNames().toArray(new String[0]))).map(Map.Entry::getValue).collect(Collectors.toList());
        }
        return this.formInfoMap.values();
    }

    private FormInfo.FormType getFormType(String type) {
        switch (type) {
            case "html": {
                return FormInfo.FormType.HTML;
            }
            case "tsx": {
                return FormInfo.FormType.TSX;
            }
        }
        return null;
    }

    @Override
    public Form getFormContent(String formName) throws IOException {
        File formFile = this.getFormFile(formName);
        File formConfig = this.getFormConfigFile(formName);
        String formConfiguration = "";
        if (formConfig == null || !formConfig.exists()) {
            throw new FileNotFoundException(formName + " dose not found");
        }
        formConfiguration = IOUtils.toString((InputStream)new FileInputStream(formConfig), (Charset)StandardCharsets.UTF_8);
        if (formFile == null || !formFile.exists()) {
            throw new FileNotFoundException(formName + "'s config file dose not found");
        }
        Form form = new Form(IOUtils.toString((InputStream)new FileInputStream(formFile), (Charset)StandardCharsets.UTF_8), new FormConfiguration(formConfiguration), formName);
        return form;
    }

    private File getFormFile(String formName) throws MalformedURLException, FileNotFoundException {
        if (this.formInfoMap.get(formName) != null) {
            FormInfo.FormType type = this.formInfoMap.get(formName).getType();
            URL formUrl = new URL(this.formsFolder.toString() + File.separator + formName + "." + type.getValue());
            return FileUtils.toFile((URL)formUrl);
        }
        throw new FileNotFoundException(formName + " dose not found");
    }

    private File getFormConfigFile(String formName) throws MalformedURLException {
        URL configUri = new URL(this.formsFolder.toString() + File.separator + formName + ".config");
        return FileUtils.toFile((URL)configUri);
    }

    @Override
    public void updateFormContent(String formContent, String formName) throws IOException {
        File formFile = this.getFormFile(formName);
        JsonObject formJsonOject = new JsonObject(formContent);
        this.verifyFormJsonOject(formJsonOject);
        FormConfiguration formConfiguration = new FormConfiguration(formJsonOject.getJsonObject("formConfiguration").toString());
        Form form = new Form(formJsonOject.getString("formContent"), formConfiguration, formName);
        IOUtils.write((String)form.getSource(), (OutputStream)new FileOutputStream(formFile), (Charset)StandardCharsets.UTF_8);
        File formConfigFile = this.getFormConfigFile(formName);
        IOUtils.write((String)form.getFormConfiguration().toString(), (OutputStream)new FileOutputStream(formConfigFile), (Charset)StandardCharsets.UTF_8);
    }

    private void verifyFormJsonOject(JsonObject formJsonObject) {
        if (formJsonObject.getString("formContent") == null || formJsonObject.getString("formContent").equals("")) {
            throw new RuntimeException("Form's json object has wrong formContent");
        }
        if (formJsonObject.getString("formConfiguration") == null) {
            throw new RuntimeException("Form's json object has wrong formConfiguration");
        }
    }

    private void reloadFormBaseInfoList() {
        this.readFormBaseList().stream().filter(file -> this.hasConfigFile(FilenameUtils.removeExtension((String)file.getName()))).forEach(file -> {
            LocalDateTime lastModified = LocalDateTime.ofInstant(Instant.ofEpochMilli(file.lastModified()), TimeZone.getDefault().toZoneId());
            this.formInfoMap.put(FilenameUtils.removeExtension((String)file.getName()), new FormInfo(FilenameUtils.removeExtension((String)file.getName()), this.getFormType(FilenameUtils.getExtension((String)file.getName())), lastModified));
        });
    }

    private Collection<File> readFormBaseList() {
        if (this.formsFolder != null) {
            LOGGER.info("form's files path is {}", (Object)this.formsFolder.toString());
            File rootFolder = FileUtils.toFile((URL)this.formsFolder);
            return FileUtils.listFiles((File)rootFolder, (String[])new String[]{"html", "tsx"}, (boolean)false);
        }
        return Collections.emptyList();
    }

    private boolean hasConfigFile(String formName) {
        try {
            return this.getFormConfigFile(formName).exists();
        }
        catch (MalformedURLException e) {
            LOGGER.info(e.getMessage());
            return false;
        }
    }
}

