/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.runtime.tools.quarkus.extension.runtime.forms.model;

import java.time.LocalDateTime;
import java.util.Objects;

public class FormInfo {
    private final String name;
    private final FormType type;
    private final LocalDateTime lastModified;

    public FormInfo(String name, FormType type, LocalDateTime lastModified) {
        this.name = name;
        this.lastModified = lastModified;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public FormType getType() {
        return this.type;
    }

    public LocalDateTime getLastModified() {
        return this.lastModified;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormInfo that = (FormInfo)o;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return Objects.equals(this.lastModified, that.lastModified);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.lastModified != null ? this.lastModified.hashCode() : 0);
        return result;
    }

    public static enum FormType {
        HTML("html"),
        TSX("tsx");

        private String value;

        private FormType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

