/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.runtime.tools.quarkus.extension.runtime.dataindex;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.ws.rs.core.Response;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.dataindex.DataIndexClient;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.dataindex.DataIndexService;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.forms.FormsStorage;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class DataIndexServiceTest {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    public static final String ERROR_RESPONSE = "something wrong happened!";
    public static final String PROCESS_INSTANCE_RESPONSE = "{\"data\":{\"ProcessInstances\":[{\"id\":\"2aa76968-5087-433a-a61f-9d3ca2feb270\"},{\"id\":\"2652e27e-127f-4b2a-961b-718a50d97212\"},{\"id\":\"5da599ad-ae7c-492f-b2c1-4a4a559dd64c\"},{\"id\":\"12ee3d38-2467-4cc0-89e6-1e6547f95cd8\"},{\"id\":\"edd5d47a-2fd1-4f8b-87a0-a8ab3f938993\"}]}}";
    public static final String EMPTY_PROCESS_INSTANCE_RESPONSE = "{\"data\":{\"ProcessInstances\":[]}}";
    public static final String USER_TASK_RESPONSE = "{\"data\":{\"UserTaskInstances\":[{\"id\":\"a859c055-3301-487a-a252-95bc35849d5c\"},{\"id\":\"cfe73332-6942-44f0-b00b-7f63349c7465\"},{\"id\":\"3ebb40a3-9ed6-4be9-bae7-5cb036870327\"},{\"id\":\"04e200d7-c191-4b29-9f6f-09c556ff5a97\"},{\"id\":\"4ab9ddff-6edb-44fa-9ed4-2b4fc797c23d\"}]}}";
    public static final String EMPTY_USER_TASK_RESPONSE = "{\"data\":{\"UserTaskInstances\":[]}}";
    public static final String JOBS_RESPONSE = "{\"data\":{\"Jobs\":[{\"id\":\"a859c055-3301-487a-a252-95bc35849d5c\"},{\"id\":\"cfe73332-6942-44f0-b00b-7f63349c7465\"},{\"id\":\"3ebb40a3-9ed6-4be9-bae7-5cb036870327\"},{\"id\":\"04e200d7-c191-4b29-9f6f-09c556ff5a97\"},{\"id\":\"4ab9ddff-6edb-44fa-9ed4-2b4fc797c23d\"}]}}";
    public static final String EMPTY_JOBS_RESPONSE = "{\"data\":{\"Jobs\":[]}}";
    @Mock
    private static DataIndexClient dataIndexClient;
    @Mock
    private FormsStorage formsStorage;
    private DataIndexService dataIndexService;

    @BeforeEach
    public void init() {
        this.dataIndexService = new DataIndexService(MAPPER, dataIndexClient, this.formsStorage);
    }

    @Test
    public void testProcessInstancesCount() {
        Mockito.when((Object)dataIndexClient.query("{ \"operationName\": \"getAllProcessesIds\", \"query\": \"query getAllProcessesIds{  ProcessInstances{ id } }\" }")).thenReturn((Object)PROCESS_INSTANCE_RESPONSE);
        Response response = this.dataIndexService.processInstancesCount();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)5, (Object)response.getEntity());
    }

    @Test
    public void testEmptyProcessInstancesCount() {
        Mockito.when((Object)dataIndexClient.query("{ \"operationName\": \"getAllProcessesIds\", \"query\": \"query getAllProcessesIds{  ProcessInstances{ id } }\" }")).thenReturn((Object)EMPTY_PROCESS_INSTANCE_RESPONSE);
        Response response = this.dataIndexService.processInstancesCount();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)0, (Object)response.getEntity());
    }

    @Test
    public void testProcessInstancestCountError() {
        Mockito.when((Object)dataIndexClient.query("{ \"operationName\": \"getAllProcessesIds\", \"query\": \"query getAllProcessesIds{  ProcessInstances{ id } }\" }")).thenReturn((Object)ERROR_RESPONSE);
        Response response = this.dataIndexService.processInstancesCount();
        Assertions.assertEquals((int)500, (int)response.getStatus());
    }

    @Test
    public void testJobsCount() {
        Mockito.when((Object)dataIndexClient.query("{ \"operationName\": \"getAllJobsIds\", \"query\": \"query getAllJobsIds{  Jobs{ id } }\" }")).thenReturn((Object)JOBS_RESPONSE);
        Response response = this.dataIndexService.jobsCount();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)5, (Object)response.getEntity());
    }

    @Test
    public void testEmptyJobsCount() {
        Mockito.when((Object)dataIndexClient.query("{ \"operationName\": \"getAllJobsIds\", \"query\": \"query getAllJobsIds{  Jobs{ id } }\" }")).thenReturn((Object)EMPTY_JOBS_RESPONSE);
        Response response = this.dataIndexService.jobsCount();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)0, (Object)response.getEntity());
    }

    @Test
    public void testJobsCountError() {
        Mockito.when((Object)dataIndexClient.query("{ \"operationName\": \"getAllJobsIds\", \"query\": \"query getAllJobsIds{  Jobs{ id } }\" }")).thenReturn((Object)ERROR_RESPONSE);
        Response response = this.dataIndexService.jobsCount();
        Assertions.assertEquals((int)500, (int)response.getStatus());
    }

    @Test
    public void testTasksCount() {
        Mockito.when((Object)dataIndexClient.query("{ \"operationName\": \"getAllTasksIds\", \"query\": \"query getAllTasksIds{  UserTaskInstances{ id } }\" }")).thenReturn((Object)USER_TASK_RESPONSE);
        Response response = this.dataIndexService.tasksCount();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)5, (Object)response.getEntity());
    }

    @Test
    public void testEmptyTasksCount() {
        Mockito.when((Object)dataIndexClient.query("{ \"operationName\": \"getAllTasksIds\", \"query\": \"query getAllTasksIds{  UserTaskInstances{ id } }\" }")).thenReturn((Object)EMPTY_USER_TASK_RESPONSE);
        Response response = this.dataIndexService.tasksCount();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)0, (Object)response.getEntity());
    }

    @Test
    public void testTasksCountError() {
        Mockito.when((Object)dataIndexClient.query("{ \"operationName\": \"getAllTasksIds\", \"query\": \"query getAllTasksIds{  UserTaskInstances{ id } }\" }")).thenReturn((Object)ERROR_RESPONSE);
        Response response = this.dataIndexService.jobsCount();
        Assertions.assertEquals((int)500, (int)response.getStatus());
    }

    @Test
    public void testFormsCount() {
        Mockito.when((Object)this.formsStorage.getFormsCount()).thenReturn((Object)5);
        Response response = this.dataIndexService.formsCount();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)5, (Object)response.getEntity());
    }

    @Test
    public void testFormsCountError() {
        Mockito.when((Object)this.formsStorage.getFormsCount()).thenThrow(new Throwable[]{new RuntimeException("something went wrong!")});
        Response response = this.dataIndexService.formsCount();
        Assertions.assertEquals((int)500, (int)response.getStatus());
    }
}

