/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.runtime.tools.quarkus.extension.runtime.forms.impl;

import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.forms.FormsStorage;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.forms.impl.FormsStorageImpl;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.forms.impl.FormsTestProfile;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.forms.model.Form;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.forms.model.FormConfiguration;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.forms.model.FormContent;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.forms.model.FormFilter;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.forms.model.FormInfo;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.forms.model.FormResources;

@QuarkusTest
@TestProfile(value=FormsTestProfile.class)
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class FormsStorageImplTest {
    private static final String TEST_FORM_CONTENT = "<div></div>";
    private static final String STYLE1 = "style1";
    private static final String SCRIPT1 = "script1";
    private static final String FORM_NAME = "hiring_HRInterview";
    private static final String PARTIAL_FORM_NAME = "hiring";
    private static final String FORM_NAME_WITH_OUT_CONFIG = "hiring_HRInterviewWithoutConfig";
    private FormsStorage formsStorage;

    @BeforeAll
    public void init() {
        URL formsFolder = Thread.currentThread().getContextClassLoader().getResource("forms");
        this.formsStorage = new FormsStorageImpl(formsFolder);
    }

    @Test
    public void testGetFormsCount() {
        Assertions.assertEquals((int)2, (int)this.formsStorage.getFormsCount());
    }

    @Test
    public void testGetFormInfoList() {
        Collection formInfosAll = this.formsStorage.getFormInfoList(null);
        Assertions.assertEquals((int)2, (int)formInfosAll.size());
        FormFilter filterEmpty = new FormFilter();
        filterEmpty.setNames(Collections.emptyList());
        Collection formInfosAllEmptyFilter = this.formsStorage.getFormInfoList(filterEmpty);
        Assertions.assertEquals((int)2, (int)formInfosAll.size());
        FormFilter filter = new FormFilter();
        filter.setNames(Arrays.asList(FORM_NAME));
        Collection formInfos = this.formsStorage.getFormInfoList(filter);
        Assertions.assertEquals((int)1, (int)formInfos.size());
        FormFilter partialFilter = new FormFilter();
        partialFilter.setNames(Arrays.asList(PARTIAL_FORM_NAME));
        Collection formInfosPartial = this.formsStorage.getFormInfoList(partialFilter);
        Assertions.assertEquals((int)2, (int)formInfosPartial.size());
    }

    @Test
    public void testGetFormContent() throws IOException {
        Form formContent = this.formsStorage.getFormContent(FORM_NAME);
        Assertions.assertNotNull((Object)formContent);
        FormInfo formInfo = formContent.getFormInfo();
        Assertions.assertEquals((Object)FORM_NAME, (Object)formInfo.getName());
    }

    @Test
    public void testGetFormContentWithoutConfig() {
        Assertions.assertThrows(RuntimeException.class, () -> this.formsStorage.getFormContent(FORM_NAME_WITH_OUT_CONFIG));
        Assertions.assertThrows(RuntimeException.class, () -> this.formsStorage.getFormContent("ERROR"));
    }

    @Test
    public void testUpdateFormContentInvalidForms() {
        Assertions.assertThrows(RuntimeException.class, () -> this.formsStorage.updateFormContent(FORM_NAME_WITH_OUT_CONFIG, new FormContent()));
        Assertions.assertThrows(RuntimeException.class, () -> this.formsStorage.updateFormContent(FORM_NAME, null));
    }

    @Test
    public void testUpdateValidForms() throws IOException {
        File storage = new File(System.getProperties().getProperty("quarkus.kogito-runtime-tools.forms.folder"));
        File sourceFile = new File(storage.toURI().resolve("hiring_HRInterview.html"));
        File configFile = new File(storage.toURI().resolve("hiring_HRInterview.config"));
        sourceFile.createNewFile();
        configFile.createNewFile();
        FileUtils.write((File)sourceFile, (CharSequence)"", (Charset)StandardCharsets.UTF_8);
        FileUtils.write((File)configFile, (CharSequence)"", (Charset)StandardCharsets.UTF_8);
        Form form = this.formsStorage.getFormContent(FORM_NAME);
        FormResources resources = new FormResources();
        resources.getStyles().put(STYLE1, STYLE1);
        resources.getScripts().put(SCRIPT1, SCRIPT1);
        FormContent content = new FormContent(TEST_FORM_CONTENT, new FormConfiguration(form.getConfiguration().getSchema(), resources));
        this.formsStorage.updateFormContent(FORM_NAME, content);
        Form newForm = this.formsStorage.getFormContent(FORM_NAME);
        Assertions.assertEquals((Object)TEST_FORM_CONTENT, (Object)newForm.getSource());
        Assertions.assertEquals((Object)form.getConfiguration().getSchema(), (Object)newForm.getConfiguration().getSchema());
        Assertions.assertEquals((Object)STYLE1, newForm.getConfiguration().getResources().getStyles().get(STYLE1));
        Assertions.assertEquals((Object)SCRIPT1, newForm.getConfiguration().getResources().getScripts().get(SCRIPT1));
        FileUtils.deleteQuietly((File)sourceFile);
        FileUtils.deleteQuietly((File)configFile);
    }
}

