/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.runtime.tools.quarkus.extension.runtime.dataindex;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.dataindex.DataIndexClient;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.dataindex.jobs.JobsResponse;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.dataindex.processes.ProcessInstancesResponse;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.dataindex.tasks.TasksResponse;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.forms.FormsStorage;

@Path(value="/dataindex")
public class DataIndexService {
    public static final String ALL_TASKS_IDS_QUERY = "{ \"operationName\": \"getAllTasksIds\", \"query\": \"query getAllTasksIds{  UserTaskInstances{ id } }\" }";
    public static final String ALL_PROCESS_INSTANCES_IDS_QUERY = "{ \"operationName\": \"getAllProcessesIds\", \"query\": \"query getAllProcessesIds{  ProcessInstances{ id } }\" }";
    public static final String ALL_JOBS_IDS_QUERY = "{ \"operationName\": \"getAllJobsIds\", \"query\": \"query getAllJobsIds{  Jobs{ id } }\" }";
    private final ObjectMapper mapper;
    private final DataIndexClient dataIndexClient;
    private final FormsStorage formsStorage;

    @Inject
    public DataIndexService(ObjectMapper mapper, @RestClient DataIndexClient dataIndexClient, FormsStorage formsStorage) {
        this.mapper = mapper;
        this.dataIndexClient = dataIndexClient;
        this.formsStorage = formsStorage;
    }

    @GET
    @Path(value="/tasks/count")
    @Produces(value={"text/plain"})
    public Response tasksCount() {
        try {
            TasksResponse tasksResponse = this.doQuery(ALL_TASKS_IDS_QUERY, TasksResponse.class);
            int tasksCount = tasksResponse.getData().getTasks().size();
            return Response.ok((Object)tasksCount).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/processInstances/count")
    @Produces(value={"text/plain"})
    public Response processInstancesCount() {
        try {
            ProcessInstancesResponse response = this.doQuery(ALL_PROCESS_INSTANCES_IDS_QUERY, ProcessInstancesResponse.class);
            int processInstancesCount = response.getData().getProcessInstances().size();
            return Response.ok((Object)processInstancesCount).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/jobs/count")
    @Produces(value={"text/plain"})
    public Response jobsCount() {
        try {
            JobsResponse jobsResponse = this.doQuery(ALL_JOBS_IDS_QUERY, JobsResponse.class);
            int jobsCount = jobsResponse.getData().getJobs().size();
            return Response.ok((Object)jobsCount).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    private <T> T doQuery(String query, Class<T> type) throws JsonProcessingException {
        String response = this.dataIndexClient.query(query);
        return (T)this.mapper.readValue(response, type);
    }

    @GET
    @Path(value="/forms/count")
    @Produces(value={"text/plain"})
    public Response formsCount() {
        try {
            int formsCount = this.formsStorage.getFormsCount();
            return Response.ok((Object)formsCount).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }
}

