/*
 * Copyright 2021 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.kogito.runtime.tools.quarkus.extension.runtime.dataindex.tasks;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

public class TaskResponseData {

    @JsonProperty("UserTaskInstances")
    private List<Task> tasks;

    public TaskResponseData() {
    }

    public TaskResponseData(final List<Task> tasks) {
        this.tasks = tasks;
    }

    public List<Task> getTasks() {
        return tasks;
    }

    public void setTasks(final List<Task> userTaskInstancesList) {
        this.tasks = userTaskInstancesList;
    }
}
