/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.runtime.tools.quarkus.extension.runtime.user;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.config.UserConfig;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.user.UserInfo;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.user.UserInfoSupplier;

class UserInfoSupplierTest {
    UserInfoSupplierTest() {
    }

    @Test
    void testNullGetUserInfo() {
        UserInfoSupplier userInfoSupplier = new UserInfoSupplier(null);
        UserInfo userInfo = userInfoSupplier.get();
        Assertions.assertEquals((int)0, (int)userInfo.getUsers().size());
        Assertions.assertEquals((Object)"[  ]", (Object)userInfo.getArrayRepresentation());
    }

    @Test
    void testEmptyGetUserInfo() {
        UserInfoSupplier userInfoSupplier = new UserInfoSupplier(Collections.emptyMap());
        UserInfo userInfo = userInfoSupplier.get();
        Assertions.assertEquals((int)0, (int)userInfo.getUsers().size());
        Assertions.assertEquals((Object)"[  ]", (Object)userInfo.getArrayRepresentation());
    }

    @Test
    void testNotEmptyGetUserInfo() {
        UserConfig userA = new UserConfig();
        userA.groups = Collections.singletonList("admin");
        UserConfig userB = new UserConfig();
        userB.groups = Arrays.asList("admin", "user");
        HashMap<String, UserConfig> userConfigByUser = new HashMap<String, UserConfig>();
        userConfigByUser.put("userA", userA);
        userConfigByUser.put("userB", userB);
        UserInfoSupplier userInfoSupplier = new UserInfoSupplier(userConfigByUser);
        UserInfo userInfo = userInfoSupplier.get();
        Assertions.assertEquals((int)2, (int)userInfo.getUsers().size());
        Assertions.assertEquals((Object)"[ { id: 'userA', groups: ['admin'] }, { id: 'userB', groups: ['admin', 'user'] } ]", (Object)userInfo.getArrayRepresentation());
    }
}

