/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.oidc.AccessTokenCredential;
import io.quarkus.oidc.runtime.AbstractOidcAuthenticationMechanism;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.smallrye.mutiny.Uni;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;

public class BearerAuthenticationMechanism
extends AbstractOidcAuthenticationMechanism {
    private static final String BEARER = "Bearer";
    protected static final ChallengeData UNAUTHORIZED_CHALLENGE = new ChallengeData(HttpResponseStatus.UNAUTHORIZED.code(), null, null);

    public Uni<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager, DefaultTenantConfigResolver resolver) {
        String token = this.extractBearerToken(context);
        if (token != null) {
            return this.authenticate(identityProviderManager, new AccessTokenCredential(token, context));
        }
        return Uni.createFrom().nullItem();
    }

    public Uni<ChallengeData> getChallenge(RoutingContext context, DefaultTenantConfigResolver resolver) {
        return Uni.createFrom().item(UNAUTHORIZED_CHALLENGE);
    }

    private String extractBearerToken(RoutingContext context) {
        HttpServerRequest request = context.request();
        String authorization = request.headers().get(HttpHeaders.AUTHORIZATION);
        if (authorization == null) {
            return null;
        }
        int idx = authorization.indexOf(32);
        if (idx <= 0 || !BEARER.equalsIgnoreCase(authorization.substring(0, idx))) {
            return null;
        }
        return authorization.substring(idx + 1);
    }
}

