/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.AccessTokenCredential;
import io.quarkus.oidc.IdTokenCredential;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.runtime.ContextAwareTokenCredential;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.oidc.runtime.TokenAutoRefreshException;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.credential.TokenCredential;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniEmitter;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.auth.oauth2.impl.OAuth2AuthProviderImpl;
import io.vertx.ext.jwt.JWT;
import io.vertx.ext.web.RoutingContext;
import java.security.Principal;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class OidcIdentityProvider
implements IdentityProvider<TokenAuthenticationRequest> {
    @Inject
    DefaultTenantConfigResolver tenantResolver;

    @Override
    public Class<TokenAuthenticationRequest> getRequestType() {
        return TokenAuthenticationRequest.class;
    }

    @Override
    public Uni<SecurityIdentity> authenticate(final TokenAuthenticationRequest request, final AuthenticationRequestContext context) {
        ContextAwareTokenCredential credential = (ContextAwareTokenCredential)request.getToken();
        final RoutingContext vertxContext = credential.getContext();
        return Uni.createFrom().deferred(new Supplier<Uni<SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> get() {
                if (OidcIdentityProvider.this.tenantResolver.isBlocking(vertxContext)) {
                    return context.runBlocking(new Supplier<SecurityIdentity>(){

                        @Override
                        public SecurityIdentity get() {
                            return (SecurityIdentity)OidcIdentityProvider.this.authenticate(request, vertxContext).await().indefinitely();
                        }
                    });
                }
                return OidcIdentityProvider.this.authenticate(request, vertxContext);
            }
        });
    }

    private Uni<SecurityIdentity> authenticate(TokenAuthenticationRequest request, RoutingContext vertxContext) {
        TenantConfigContext resolvedContext = this.tenantResolver.resolve(vertxContext, true);
        if (resolvedContext.oidcConfig.publicKey.isPresent()) {
            return OidcIdentityProvider.validateTokenWithoutOidcServer(request, resolvedContext);
        }
        return this.validateTokenWithOidcServer(vertxContext, request, resolvedContext);
    }

    private Uni<SecurityIdentity> validateTokenWithOidcServer(final RoutingContext vertxContext, final TokenAuthenticationRequest request, final TenantConfigContext resolvedContext) {
        if (request.getToken() instanceof IdTokenCredential && (resolvedContext.oidcConfig.authentication.verifyAccessToken || resolvedContext.oidcConfig.roles.source.orElse(null) == OidcTenantConfig.Roles.Source.accesstoken)) {
            vertxContext.put("code_flow_access_token_result", OidcIdentityProvider.verifyCodeFlowAccessToken(vertxContext, request, resolvedContext));
        }
        return Uni.createFrom().emitter(new Consumer<UniEmitter<? super SecurityIdentity>>(){

            @Override
            public void accept(final UniEmitter<? super SecurityIdentity> uniEmitter) {
                resolvedContext.auth.decodeToken(request.getToken().getToken(), new Handler<AsyncResult<AccessToken>>(){

                    @Override
                    public void handle(AsyncResult<AccessToken> event) {
                        if (event.failed()) {
                            uniEmitter.fail(new AuthenticationFailedException(event.cause()));
                            return;
                        }
                        TokenCredential tokenCred = request.getToken();
                        JsonObject tokenJson = event.result().accessToken();
                        if (tokenJson == null) {
                            tokenJson = OidcUtils.decodeJwtContent(tokenCred.getToken());
                        }
                        JsonObject userInfo = null;
                        if (resolvedContext.oidcConfig.authentication.isUserInfoRequired()) {
                            userInfo = OidcIdentityProvider.getUserInfo(event.result(), (String)vertxContext.get("access_token"));
                        }
                        if (tokenJson != null) {
                            OidcUtils.validatePrimaryJwtTokenType(resolvedContext.oidcConfig.token, tokenJson);
                            JsonObject rolesJson = OidcIdentityProvider.getRolesJson(vertxContext, resolvedContext, tokenCred, tokenJson, userInfo);
                            try {
                                QuarkusSecurityIdentity securityIdentity = OidcUtils.validateAndCreateIdentity(vertxContext, tokenCred, resolvedContext.oidcConfig, tokenJson, rolesJson, userInfo);
                                if (OidcIdentityProvider.tokenAutoRefreshPrepared(tokenJson, vertxContext, resolvedContext.oidcConfig)) {
                                    throw new TokenAutoRefreshException(securityIdentity);
                                }
                                uniEmitter.complete(securityIdentity);
                            }
                            catch (Throwable ex) {
                                uniEmitter.fail(ex);
                            }
                        } else if (tokenCred instanceof IdTokenCredential || tokenCred instanceof AccessTokenCredential && !((AccessTokenCredential)tokenCred).isOpaque()) {
                            uniEmitter.fail(new AuthenticationFailedException("JWT token can not be converted to JSON"));
                        } else {
                            QuarkusSecurityIdentity.Builder builder = QuarkusSecurityIdentity.builder();
                            builder.addCredential(tokenCred);
                            OidcUtils.setSecurityIdentityUserInfo(builder, userInfo);
                            if (event.result().principal().containsKey("username")) {
                                final String userName = event.result().principal().getString("username");
                                builder.setPrincipal(new Principal(){

                                    @Override
                                    public String getName() {
                                        return userName;
                                    }
                                });
                            }
                            if (event.result().principal().containsKey("scope")) {
                                for (String role : event.result().principal().getString("scope").split(" ")) {
                                    builder.addRole(role.trim());
                                }
                            }
                            uniEmitter.complete(builder.build());
                        }
                    }
                });
            }
        });
    }

    private static boolean tokenAutoRefreshPrepared(JsonObject tokenJson, RoutingContext vertxContext, OidcTenantConfig oidcConfig) {
        if (tokenJson != null && oidcConfig.token.refreshExpired && oidcConfig.token.autoRefreshInterval.isPresent() && vertxContext.get("tokenAutoRefreshInProgress") != Boolean.TRUE && vertxContext.get("new_authentication") != Boolean.TRUE) {
            long autoRefreshInterval = oidcConfig.token.autoRefreshInterval.get().getSeconds();
            long expiry = tokenJson.getLong("exp");
            long now = System.currentTimeMillis() / 1000L;
            if (now + autoRefreshInterval > expiry) {
                vertxContext.put("tokenAutoRefreshInProgress", Boolean.TRUE);
                return true;
            }
        }
        return false;
    }

    private static JsonObject getRolesJson(RoutingContext vertxContext, TenantConfigContext resolvedContext, TokenCredential tokenCred, JsonObject tokenJson, JsonObject userInfo) {
        JsonObject rolesJson = tokenJson;
        if (tokenCred instanceof IdTokenCredential && resolvedContext.oidcConfig.roles.source.isPresent()) {
            if (resolvedContext.oidcConfig.roles.source.get() == OidcTenantConfig.Roles.Source.userinfo) {
                rolesJson = userInfo;
            } else if (resolvedContext.oidcConfig.roles.source.get() == OidcTenantConfig.Roles.Source.accesstoken) {
                AccessToken result = (AccessToken)vertxContext.get("code_flow_access_token_result");
                rolesJson = result.accessToken();
                if (rolesJson == null) {
                    rolesJson = OidcUtils.decodeJwtContent((String)vertxContext.get("access_token"));
                }
                if (rolesJson == null) {
                    rolesJson = result.principal();
                }
            }
        }
        return rolesJson;
    }

    private static AccessToken verifyCodeFlowAccessToken(final RoutingContext vertxContext, TokenAuthenticationRequest request, final TenantConfigContext resolvedContext) {
        return Uni.createFrom().emitter(new Consumer<UniEmitter<? super AccessToken>>(){

            @Override
            public void accept(final UniEmitter<? super AccessToken> uniEmitter) {
                resolvedContext.auth.decodeToken((String)vertxContext.get("access_token"), new Handler<AsyncResult<AccessToken>>(){

                    @Override
                    public void handle(AsyncResult<AccessToken> event) {
                        if (event.failed()) {
                            uniEmitter.fail(new AuthenticationFailedException(event.cause()));
                        }
                        uniEmitter.complete(event.result());
                    }
                });
            }
        }).await().indefinitely();
    }

    private static Uni<SecurityIdentity> validateTokenWithoutOidcServer(TokenAuthenticationRequest request, TenantConfigContext resolvedContext) {
        OAuth2AuthProviderImpl auth = (OAuth2AuthProviderImpl)resolvedContext.auth;
        JWT jwt = auth.getJWT();
        JsonObject tokenJson = null;
        try {
            tokenJson = jwt.decode(request.getToken().getToken());
        }
        catch (Throwable ex) {
            return Uni.createFrom().failure(new AuthenticationFailedException(ex));
        }
        if (jwt.isExpired(tokenJson, auth.getConfig().getJWTOptions())) {
            return Uni.createFrom().failure(new AuthenticationFailedException());
        }
        try {
            return Uni.createFrom().item(OidcUtils.validateAndCreateIdentity(null, request.getToken(), resolvedContext.oidcConfig, tokenJson, tokenJson, null));
        }
        catch (Throwable ex) {
            return Uni.createFrom().failure(ex);
        }
    }

    private static JsonObject getUserInfo(final AccessToken tokenImpl, final String opaqueAccessToken) {
        return Uni.createFrom().emitter(new Consumer<UniEmitter<? super JsonObject>>(){

            @Override
            public void accept(final UniEmitter<? super JsonObject> uniEmitter) {
                tokenImpl.principal().put("access_token", opaqueAccessToken);
                tokenImpl.userInfo(new Handler<AsyncResult<JsonObject>>(){

                    @Override
                    public void handle(AsyncResult<JsonObject> event) {
                        if (event.failed()) {
                            uniEmitter.fail(event.cause());
                        } else {
                            uniEmitter.complete(event.result());
                        }
                    }
                });
            }
        }).await().indefinitely();
    }
}

