/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.security;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.keycloak.representations.AccessTokenResponse;
import org.kie.kogito.test.quarkus.QuarkusTestProperty;
import org.kie.kogito.testcontainers.quarkus.KeycloakQuarkusTestResource;

@QuarkusTest
@QuarkusTestResource(value=KeycloakQuarkusTestResource.class)
class KeycloakSecurityCommonsServiceIT {
    public static final int OK_CODE = 200;
    public static final int FORBIDDEN_CODE = 401;
    @QuarkusTestProperty(name="quarkus.oidc.auth-server-url")
    String keycloakURL;

    KeycloakSecurityCommonsServiceIT() {
    }

    @Test
    void meTest() throws Exception {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().oauth2(this.getAccessToken("jdoe")).when().get("/api/user/me", new Object[0])).then()).statusCode(200)).body("userName", CoreMatchers.is((Object)"jdoe"), new Object[0])).body("roles", Matchers.hasSize((int)2), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().oauth2(this.getAccessToken("alice")).when().get("/api/user/me", new Object[0])).then()).statusCode(200)).body("userName", CoreMatchers.is((Object)"alice"), new Object[0])).body("roles", Matchers.hasSize((int)1), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().when().get("/api/user/me", new Object[0])).then()).statusCode(401);
    }

    private String getAccessToken(String userName) {
        return ((AccessTokenResponse)((Response)RestAssured.given().param("grant_type", new Object[]{"password"}).param("username", new Object[]{userName}).param("password", new Object[]{userName}).param("client_id", new Object[]{"kogito-app"}).param("client_secret", new Object[]{"secret"}).when().post(this.keycloakURL + "/protocol/openid-connect/token", new Object[0])).as(AccessTokenResponse.class)).getToken();
    }
}

