/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.security;

import io.quarkus.security.Authenticated;
import io.quarkus.security.credential.TokenCredential;
import io.quarkus.security.identity.SecurityIdentity;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Collections;
import java.util.Set;
import org.jboss.resteasy.annotations.cache.NoCache;

@Path(value="/api/user")
@Authenticated
public class UserResource {
    public static final String USER_PATH = "/api/user";
    @Inject
    SecurityIdentity identity;

    @GET
    @Path(value="/me")
    @Produces(value={"application/json"})
    @NoCache
    public User me() {
        return new User(this.identity);
    }

    protected void setSecurityIdentity(SecurityIdentity securityIdentity) {
        this.identity = securityIdentity;
    }

    public static class User {
        private String userName = "Anonymous";
        private Set<String> roles = Collections.emptySet();
        private String token = "";

        User(SecurityIdentity identity) {
            if (identity != null && identity.getPrincipal() != null && identity.getCredential(TokenCredential.class) != null) {
                this.userName = identity.getPrincipal().getName();
                this.roles = identity.getRoles();
                this.token = ((TokenCredential)identity.getCredential(TokenCredential.class)).getToken();
            }
        }

        public String getUserName() {
            return this.userName;
        }

        public Set<String> getRoles() {
            return this.roles;
        }

        public String getToken() {
            return this.token;
        }
    }
}

