/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.examples;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.runner.RunWith;
import org.kie.kogito.Model;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.serverless.examples.ServerlessServiceCallsExampleApplication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

@SpringBootTest(classes={ServerlessServiceCallsExampleApplication.class})
@RunWith(value=SpringRunner.class)
public class CountriesWorkflowIntegrationTest {
    @Autowired
    @Qualifier(value="jsonservicecall")
    Process<? extends Model> jsonServiceCallWorkflow;

    @Test
    public void testJsonServiceCallWorkflow() throws Exception {
        Assertions.assertNotNull(this.jsonServiceCallWorkflow);
        Model m = (Model)this.jsonServiceCallWorkflow.createModel();
        HashMap<String, JsonNode> parameters = new HashMap<String, JsonNode>();
        String testCountryStr = "{\"name\": \"Greece\"}";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode workflowDataInput = mapper.readTree(testCountryStr);
        parameters.put("workflowdata", workflowDataInput);
        m.fromMap(parameters);
        ProcessInstance processInstance = this.jsonServiceCallWorkflow.createInstance(m);
        processInstance.start();
        Assertions.assertEquals((int)2, (int)processInstance.status());
        Model result = (Model)processInstance.variables();
        Assertions.assertEquals((int)1, (int)result.toMap().size());
        JsonNode workflowDataNode = (JsonNode)result.toMap().get("workflowdata");
        Assertions.assertNotNull((Object)workflowDataNode);
        Assertions.assertEquals((Object)"Athens", (Object)workflowDataNode.get("capital").textValue());
        Assertions.assertEquals((Object)"Europe", (Object)workflowDataNode.get("region").textValue());
        Assertions.assertEquals((Object)"Greece", (Object)workflowDataNode.get("name").textValue());
        Assertions.assertEquals((Object)"Small/Medium", (Object)workflowDataNode.get("classifier").textValue());
    }
}

