/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.examples;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Set;
import org.kie.kogito.serverless.examples.Country;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.ApplicationScope;

@Component
@ApplicationScope
public class ClassifierService {
    private static final Logger LOG = LoggerFactory.getLogger(ClassifierService.class);
    private Set<Country> classifiedCountries = Collections.newSetFromMap(Collections.synchronizedMap(new LinkedHashMap()));

    public JsonNode classifySmallMedium(JsonNode classifiedCountryNode) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            Country classifiedCountry = (Country)mapper.treeToValue((TreeNode)classifiedCountryNode.get("response").get(0), Country.class);
            classifiedCountry.setClassifier("Small/Medium");
            this.classifiedCountries.add(classifiedCountry);
            JsonNode retNode = (JsonNode)mapper.convertValue((Object)classifiedCountry, JsonNode.class);
            return retNode;
        }
        catch (Exception e) {
            LOG.error("unable to classify country: " + classifiedCountryNode.toString());
            return classifiedCountryNode;
        }
    }

    public JsonNode classifyLarge(JsonNode classifiedCountryNode) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            Country classifiedCountry = (Country)mapper.treeToValue((TreeNode)classifiedCountryNode.get("response").get(0), Country.class);
            classifiedCountry.setClassifier("Large");
            this.classifiedCountries.add(classifiedCountry);
            JsonNode retNode = (JsonNode)mapper.convertValue((Object)classifiedCountry, JsonNode.class);
            return retNode;
        }
        catch (Exception e) {
            LOG.error("unable to classify country: " + classifiedCountryNode.toString());
            return classifiedCountryNode;
        }
    }

    public Set<Country> getClassifiedCountries() {
        return this.classifiedCountries;
    }
}

