/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime.standalone;

import io.netty.buffer.ByteBuf;
import io.quarkus.resteasy.runtime.standalone.BufferAllocator;
import io.quarkus.resteasy.runtime.standalone.VertxHttpResponse;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jboss.resteasy.spi.AsyncOutputStream;

public class VertxOutputStream
extends AsyncOutputStream {
    private final VertxHttpResponse response;
    private final BufferAllocator allocator;
    private ByteBuf pooledBuffer;
    private long written;
    private final long contentLength;
    private boolean closed;

    public VertxOutputStream(VertxHttpResponse response, BufferAllocator allocator) {
        this.allocator = allocator;
        this.response = response;
        Object length = response.getOutputHeaders().getFirst("Content-Length");
        this.contentLength = length == null ? -1L : Long.parseLong(length.toString());
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len < 1) {
            return;
        }
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        int rem = len;
        int idx = off;
        ByteBuf buffer = this.pooledBuffer;
        try {
            if (buffer == null) {
                this.pooledBuffer = buffer = this.allocator.allocateBuffer();
            }
            while (rem > 0) {
                int toWrite = Math.min(rem, buffer.writableBytes());
                buffer.writeBytes(b, idx, toWrite);
                rem -= toWrite;
                idx += toWrite;
                if (buffer.isWritable()) continue;
                ByteBuf tmpBuf = buffer;
                this.pooledBuffer = buffer = this.allocator.allocateBuffer();
                this.response.writeBlocking(tmpBuf, false);
            }
        }
        catch (Exception e) {
            if (buffer != null && buffer.refCnt() > 0) {
                buffer.release();
            }
            throw new IOException(e);
        }
        this.updateWritten(len);
    }

    void updateWritten(long len) throws IOException {
        this.written += len;
        if (this.contentLength != -1L && this.written >= this.contentLength) {
            this.flush();
            this.close();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        try {
            if (this.pooledBuffer != null) {
                this.response.writeBlocking(this.pooledBuffer, false);
                this.pooledBuffer = null;
            }
        }
        catch (Exception e) {
            if (this.pooledBuffer != null) {
                this.pooledBuffer.release();
                this.pooledBuffer = null;
            }
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.response.writeBlocking(this.pooledBuffer, true);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            this.closed = true;
            this.pooledBuffer = null;
        }
    }

    @Override
    public CompletionStage<Void> asyncFlush() {
        return this.asyncFlush(false);
    }

    private CompletionStage<Void> asyncFlush(boolean isLast) {
        if (this.closed) {
            CompletableFuture<Void> ret = new CompletableFuture<Void>();
            ret.completeExceptionally(new IOException("Stream is closed"));
            return ret;
        }
        if (this.pooledBuffer != null) {
            ByteBuf sentBuffer = this.pooledBuffer;
            this.pooledBuffer = null;
            CompletionStage<Void> ret = this.response.writeNonBlocking(sentBuffer, isLast);
            return ret.whenComplete((v, t) -> {
                if (t != null) {
                    sentBuffer.release();
                }
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletionStage<Void> asyncWrite(byte[] b, int off, int len) {
        if (len < 1) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.closed) {
            CompletableFuture<Void> ret = new CompletableFuture<Void>();
            ret.completeExceptionally(new IOException("Stream is closed"));
            return ret;
        }
        int rem = len;
        int idx = off;
        ByteBuf buffer = this.pooledBuffer;
        CompletionStage<Object> ret = CompletableFuture.completedFuture(null);
        if (buffer == null) {
            this.pooledBuffer = buffer = this.allocator.allocateBuffer();
        }
        while (rem > 0) {
            int toWrite = Math.min(rem, buffer.writableBytes());
            buffer.writeBytes(b, idx, toWrite);
            rem -= toWrite;
            idx += toWrite;
            if (buffer.isWritable()) continue;
            ByteBuf tmpBuf = buffer;
            this.pooledBuffer = buffer = this.allocator.allocateBuffer();
            ret = ret.thenCompose(v -> this.response.writeNonBlocking(tmpBuf, false).whenComplete((v2, t) -> {
                if (t != null) {
                    tmpBuf.release();
                }
            }));
        }
        return ret.thenCompose(v -> this.asyncUpdateWritten(len));
    }

    CompletionStage<Void> asyncUpdateWritten(long len) {
        this.written += len;
        if (this.contentLength != -1L && this.written >= this.contentLength) {
            return this.asyncFlush(true).thenAccept(v -> {
                this.closed = true;
            });
        }
        return CompletableFuture.completedFuture(null);
    }
}

