/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.core.runtime;

import io.netty.channel.EventLoopGroup;
import io.quarkus.runtime.IOThreadDetector;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.core.runtime.SSLConfigHelper;
import io.quarkus.vertx.core.runtime.config.ClusterConfiguration;
import io.quarkus.vertx.core.runtime.config.EventBusConfiguration;
import io.quarkus.vertx.core.runtime.config.VertxConfiguration;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.eventbus.EventBusOptions;
import io.vertx.core.file.FileSystemOptions;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.impl.VertxImpl;
import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.wildfly.common.cpu.ProcessorInfo;

@Recorder
public class VertxCoreRecorder {
    private static final Logger LOGGER = Logger.getLogger(VertxCoreRecorder.class.getName());
    static volatile VertxSupplier vertx;

    public Supplier<Vertx> configureVertx(VertxConfiguration config, LaunchMode launchMode, ShutdownContext shutdown, List<Consumer<VertxOptions>> customizers) {
        vertx = new VertxSupplier(config, customizers);
        if (launchMode != LaunchMode.DEVELOPMENT) {
            shutdown.addLastShutdownTask(new Runnable(){

                @Override
                public void run() {
                    VertxCoreRecorder.this.destroy();
                }
            });
        }
        return vertx;
    }

    public IOThreadDetector detector() {
        return new IOThreadDetector(){

            @Override
            public boolean isInIOThread() {
                return Context.isOnEventLoopThread();
            }
        };
    }

    static void shutdownDevMode() {
        if (vertx != null) {
            final CountDownLatch latch = new CountDownLatch(1);
            vertx.get().close(new Handler<AsyncResult<Void>>(){

                @Override
                public void handle(AsyncResult<Void> event) {
                    latch.countDown();
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static Supplier<Vertx> getVertx() {
        return vertx;
    }

    public static Vertx initialize(VertxConfiguration conf, VertxOptionsCustomizer customizer) {
        Vertx vertx;
        VertxOptions options = new VertxOptions();
        if (conf != null) {
            VertxCoreRecorder.convertToVertxOptions(conf, options, true);
        }
        if (customizer != null) {
            customizer.customize(options);
        }
        if (options.getEventBusOptions().isClustered()) {
            CompletableFuture latch = new CompletableFuture();
            Vertx.clusteredVertx(options, ar -> {
                if (ar.failed()) {
                    latch.completeExceptionally(ar.cause());
                } else {
                    latch.complete(ar.result());
                }
            });
            vertx = (Vertx)latch.join();
        } else {
            vertx = Vertx.vertx(options);
        }
        return VertxCoreRecorder.logVertxInitialization(vertx);
    }

    private static Vertx logVertxInitialization(Vertx vertx) {
        LOGGER.debugf("Vertx has Native Transport Enabled: %s", (Object)vertx.isNativeTransportEnabled());
        return vertx;
    }

    private static VertxOptions convertToVertxOptions(VertxConfiguration conf, VertxOptions options, boolean allowClustering) {
        Optional<Duration> maxWorkerExecuteTime;
        if (!conf.useAsyncDNS) {
            System.setProperty("vertx.disableDnsResolver", "true");
        }
        if (allowClustering) {
            VertxCoreRecorder.setEventBusOptions(conf, options);
            VertxCoreRecorder.initializeClusterOptions(conf, options);
        }
        String fileCacheDir = System.getProperty("vertx.cacheDirBase", System.getProperty("java.io.tmpdir", ".") + File.separator + "vertx-cache");
        options.setFileSystemOptions(new FileSystemOptions().setFileCachingEnabled(conf.caching).setFileCacheDir(fileCacheDir).setClassPathResolvingEnabled(conf.classpathResolving));
        options.setWorkerPoolSize(conf.workerPoolSize);
        options.setInternalBlockingPoolSize(conf.internalBlockingPoolSize);
        options.setBlockedThreadCheckInterval(conf.warningExceptionTime.toMillis());
        if (conf.eventLoopsPoolSize.isPresent()) {
            options.setEventLoopPoolSize(conf.eventLoopsPoolSize.getAsInt());
        } else {
            options.setEventLoopPoolSize(VertxCoreRecorder.calculateDefaultIOThreads());
        }
        Optional<Duration> maxEventLoopExecuteTime = conf.maxEventLoopExecuteTime;
        if (maxEventLoopExecuteTime.isPresent()) {
            options.setMaxEventLoopExecuteTime(maxEventLoopExecuteTime.get().toMillis());
            options.setMaxEventLoopExecuteTimeUnit(TimeUnit.MILLISECONDS);
        }
        if ((maxWorkerExecuteTime = conf.maxWorkerExecuteTime).isPresent()) {
            options.setMaxWorkerExecuteTime(maxWorkerExecuteTime.get().toMillis());
            options.setMaxWorkerExecuteTimeUnit(TimeUnit.MILLISECONDS);
        }
        options.setWarningExceptionTime(conf.warningExceptionTime.toNanos());
        options.setPreferNativeTransport(conf.preferNativeTransport);
        return options;
    }

    private static int calculateDefaultIOThreads() {
        int recommended = ProcessorInfo.availableProcessors() * 2;
        long mem = Runtime.getRuntime().maxMemory();
        long memInMb = mem / 0x100000L;
        long maxAllowed = memInMb / 10L;
        return (int)Math.max(2L, Math.min(maxAllowed, (long)recommended));
    }

    void destroy() {
        if (vertx != null && VertxCoreRecorder.vertx.v != null) {
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference problem = new AtomicReference();
            VertxCoreRecorder.vertx.v.close(ar -> {
                if (ar.failed()) {
                    problem.set(ar.cause());
                }
                latch.countDown();
            });
            try {
                latch.await();
                if (problem.get() != null) {
                    throw new IllegalStateException("Error when closing Vert.x instance", (Throwable)problem.get());
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Interrupted when closing Vert.x instance", e);
            }
            vertx = null;
        }
    }

    private static void initializeClusterOptions(VertxConfiguration conf, VertxOptions options) {
        ClusterConfiguration cluster = conf.cluster;
        options.getEventBusOptions().setClustered(cluster.clustered);
        options.getEventBusOptions().setClusterPingReplyInterval(cluster.pingReplyInterval.toMillis());
        options.getEventBusOptions().setClusterPingInterval(cluster.pingInterval.toMillis());
        if (cluster.host != null) {
            options.getEventBusOptions().setHost(cluster.host);
        }
        if (cluster.port.isPresent()) {
            options.getEventBusOptions().setPort(cluster.port.getAsInt());
        }
        cluster.publicHost.ifPresent(options.getEventBusOptions()::setClusterPublicHost);
        if (cluster.publicPort.isPresent()) {
            options.getEventBusOptions().setPort(cluster.publicPort.getAsInt());
        }
    }

    private static void setEventBusOptions(VertxConfiguration conf, VertxOptions options) {
        EventBusConfiguration eb = conf.eventbus;
        EventBusOptions opts = new EventBusOptions();
        opts.setAcceptBacklog(eb.acceptBacklog.orElse(-1));
        opts.setClientAuth(ClientAuth.valueOf(eb.clientAuth.toUpperCase()));
        opts.setConnectTimeout((int)Math.min(Integer.MAX_VALUE, eb.connectTimeout.toMillis()));
        opts.setIdleTimeout(eb.idleTimeout.isPresent() ? (int)Math.max(1L, Math.min(Integer.MAX_VALUE, eb.idleTimeout.get().getSeconds())) : 0);
        opts.setSendBufferSize(eb.sendBufferSize.orElse(-1));
        opts.setSoLinger(eb.soLinger.orElse(-1));
        opts.setSsl(eb.ssl);
        opts.setReceiveBufferSize(eb.receiveBufferSize.orElse(-1));
        opts.setReconnectAttempts(eb.reconnectAttempts);
        opts.setReconnectInterval(eb.reconnectInterval.toMillis());
        opts.setReuseAddress(eb.reuseAddress);
        opts.setReusePort(eb.reusePort);
        opts.setTrafficClass(eb.trafficClass.orElse(-1));
        opts.setTcpKeepAlive(eb.tcpKeepAlive);
        opts.setTcpNoDelay(eb.tcpNoDelay);
        opts.setTrustAll(eb.trustAll);
        SSLConfigHelper.configurePemKeyCertOptions(opts, eb.keyCertificatePem);
        SSLConfigHelper.configureJksKeyCertOptions(opts, eb.keyCertificateJks);
        SSLConfigHelper.configurePfxKeyCertOptions(opts, eb.keyCertificatePfx);
        SSLConfigHelper.configurePemTrustOptions(opts, eb.trustCertificatePem);
        SSLConfigHelper.configureJksKeyCertOptions(opts, eb.trustCertificateJks);
        SSLConfigHelper.configurePfxTrustOptions(opts, eb.trustCertificatePfx);
        options.setEventBusOptions(opts);
    }

    public Supplier<EventLoopGroup> bossSupplier() {
        return new Supplier<EventLoopGroup>(){

            @Override
            public EventLoopGroup get() {
                return ((VertxImpl)vertx.get()).getAcceptorEventLoopGroup();
            }
        };
    }

    public Supplier<EventLoopGroup> mainSupplier() {
        return new Supplier<EventLoopGroup>(){

            @Override
            public EventLoopGroup get() {
                return vertx.get().nettyEventLoopGroup();
            }
        };
    }

    public Supplier<Integer> calculateEventLoopThreads(VertxConfiguration conf) {
        final int threads = conf.eventLoopsPoolSize.isPresent() ? conf.eventLoopsPoolSize.getAsInt() : VertxCoreRecorder.calculateDefaultIOThreads();
        return new Supplier<Integer>(){

            @Override
            public Integer get() {
                return threads;
            }
        };
    }

    static class VertxOptionsCustomizer {
        final List<Consumer<VertxOptions>> customizers;

        VertxOptionsCustomizer(List<Consumer<VertxOptions>> customizers) {
            this.customizers = customizers;
        }

        VertxOptions customize(VertxOptions options) {
            for (Consumer<VertxOptions> x : this.customizers) {
                x.accept(options);
            }
            return options;
        }
    }

    static class VertxSupplier
    implements Supplier<Vertx> {
        final VertxConfiguration config;
        final VertxOptionsCustomizer customizer;
        Vertx v;

        VertxSupplier(VertxConfiguration config, List<Consumer<VertxOptions>> customizers) {
            this.config = config;
            this.customizer = new VertxOptionsCustomizer(customizers);
        }

        @Override
        public synchronized Vertx get() {
            if (this.v == null) {
                this.v = VertxCoreRecorder.initialize(this.config, this.customizer);
            }
            return this.v;
        }
    }
}

