/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.attribute;

import io.quarkus.vertx.http.runtime.attribute.ExchangeAttribute;
import io.quarkus.vertx.http.runtime.attribute.ExchangeAttributeBuilder;
import io.quarkus.vertx.http.runtime.attribute.ReadOnlyAttributeException;
import io.vertx.ext.web.RoutingContext;
import java.util.List;

public class ResponseHeaderAttribute
implements ExchangeAttribute {
    private final String responseHeader;

    public ResponseHeaderAttribute(String responseHeader) {
        this.responseHeader = responseHeader;
    }

    @Override
    public String readAttribute(RoutingContext exchange) {
        List<String> header = exchange.response().headers().getAll(this.responseHeader);
        if (header.isEmpty()) {
            return null;
        }
        if (header.size() == 1) {
            return header.get(0);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < header.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(header.get(i));
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void writeAttribute(RoutingContext exchange, String newValue) throws ReadOnlyAttributeException {
        if (newValue == null) {
            exchange.response().headers().remove(this.responseHeader);
        } else {
            exchange.response().headers().set(this.responseHeader, newValue);
        }
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Response header";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.startsWith("%{o,") && token.endsWith("}")) {
                String headerName = token.substring(4, token.length() - 1);
                return new ResponseHeaderAttribute(headerName);
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

