/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Predicates;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.UniSerializedSubscriber;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;

public class UniRetryAtMost<T>
extends UniOperator<T, T> {
    private final Predicate<? super Throwable> predicate;
    private final long maxAttempts;

    public UniRetryAtMost(Uni<T> upstream, Predicate<? super Throwable> predicate, long maxAttempts) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.predicate = ParameterValidation.nonNull(predicate, "predicate");
        this.maxAttempts = ParameterValidation.positive(maxAttempts, "maxAttempts");
    }

    @Override
    protected void subscribing(final UniSerializedSubscriber<? super T> subscriber) {
        final AtomicInteger numberOfSubscriptions = new AtomicInteger(0);
        UniSubscriber retryingSubscriber = new UniSubscriber<T>(){
            AtomicReference<UniSubscription> reference = new AtomicReference();

            @Override
            public void onSubscribe(UniSubscription subscription) {
                if (numberOfSubscriptions.getAndIncrement() == 0) {
                    subscriber.onSubscribe(() -> {
                        UniSubscription old = this.reference.getAndSet(EmptyUniSubscription.CANCELLED);
                        if (old != null) {
                            old.cancel();
                        }
                    });
                } else {
                    this.reference.compareAndSet(null, subscription);
                }
            }

            @Override
            public void onItem(T item) {
                if (this.reference.get() != EmptyUniSubscription.CANCELLED) {
                    subscriber.onItem(item);
                }
            }

            @Override
            public void onFailure(Throwable failure) {
                if (this.reference.get() != EmptyUniSubscription.CANCELLED) {
                    if (!Predicates.testFailure(UniRetryAtMost.this.predicate, subscriber, failure)) {
                        return;
                    }
                    if ((long)numberOfSubscriptions.get() > UniRetryAtMost.this.maxAttempts) {
                        subscriber.onFailure(failure);
                        return;
                    }
                    UniSubscription old = this.reference.getAndSet(null);
                    if (old != null) {
                        old.cancel();
                    }
                    UniRetryAtMost.this.resubscribe(UniRetryAtMost.this.upstream(), this);
                }
            }
        };
        AbstractUni.subscribe(this.upstream(), retryingSubscriber);
    }

    private void resubscribe(Uni<? extends T> upstream, UniSubscriber<T> subscriber) {
        AbstractUni.subscribe(upstream, subscriber);
    }
}

