/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.axle.core.dns;

import io.vertx.axle.AsyncResultCompletionStage;
import io.vertx.axle.core.dns.MxRecord;
import io.vertx.axle.core.dns.SrvRecord;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.axle.Gen;
import io.vertx.lang.axle.TypeArg;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

@Gen(value=io.vertx.core.dns.DnsClient.class)
public class DnsClient {
    public static final TypeArg<DnsClient> __TYPE_ARG = new TypeArg<DnsClient>(obj -> new DnsClient((io.vertx.core.dns.DnsClient)obj), DnsClient::getDelegate);
    private final io.vertx.core.dns.DnsClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DnsClient that = (DnsClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public DnsClient(io.vertx.core.dns.DnsClient delegate) {
        this.delegate = delegate;
    }

    DnsClient() {
        this.delegate = null;
    }

    public io.vertx.core.dns.DnsClient getDelegate() {
        return this.delegate;
    }

    private DnsClient __lookup(String name, Handler<AsyncResult<String>> handler) {
        this.delegate.lookup(name, handler);
        return this;
    }

    public CompletionStage<String> lookup(String name) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__lookup(name, (Handler<AsyncResult<String>>)handler));
    }

    private DnsClient __lookup4(String name, Handler<AsyncResult<String>> handler) {
        this.delegate.lookup4(name, handler);
        return this;
    }

    public CompletionStage<String> lookup4(String name) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__lookup4(name, (Handler<AsyncResult<String>>)handler));
    }

    private DnsClient __lookup6(String name, Handler<AsyncResult<String>> handler) {
        this.delegate.lookup6(name, handler);
        return this;
    }

    public CompletionStage<String> lookup6(String name) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__lookup6(name, (Handler<AsyncResult<String>>)handler));
    }

    private DnsClient __resolveA(String name, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveA(name, handler);
        return this;
    }

    public CompletionStage<List<String>> resolveA(String name) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__resolveA(name, (Handler<AsyncResult<List<String>>>)handler));
    }

    private DnsClient __resolveAAAA(String name, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveAAAA(name, handler);
        return this;
    }

    public CompletionStage<List<String>> resolveAAAA(String name) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__resolveAAAA(name, (Handler<AsyncResult<List<String>>>)handler));
    }

    private DnsClient __resolveCNAME(String name, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveCNAME(name, handler);
        return this;
    }

    public CompletionStage<List<String>> resolveCNAME(String name) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__resolveCNAME(name, (Handler<AsyncResult<List<String>>>)handler));
    }

    private DnsClient __resolveMX(String name, final Handler<AsyncResult<List<MxRecord>>> handler) {
        this.delegate.resolveMX(name, new Handler<AsyncResult<List<io.vertx.core.dns.MxRecord>>>(){

            @Override
            public void handle(AsyncResult<List<io.vertx.core.dns.MxRecord>> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(ar.result().stream().map(elt -> MxRecord.newInstance(elt)).collect(Collectors.toList())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public CompletionStage<List<MxRecord>> resolveMX(String name) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__resolveMX(name, (Handler<AsyncResult<List<MxRecord>>>)handler));
    }

    private DnsClient __resolveTXT(String name, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveTXT(name, handler);
        return this;
    }

    public CompletionStage<List<String>> resolveTXT(String name) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__resolveTXT(name, (Handler<AsyncResult<List<String>>>)handler));
    }

    private DnsClient __resolvePTR(String name, Handler<AsyncResult<String>> handler) {
        this.delegate.resolvePTR(name, handler);
        return this;
    }

    public CompletionStage<String> resolvePTR(String name) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__resolvePTR(name, (Handler<AsyncResult<String>>)handler));
    }

    private DnsClient __resolveNS(String name, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveNS(name, handler);
        return this;
    }

    public CompletionStage<List<String>> resolveNS(String name) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__resolveNS(name, (Handler<AsyncResult<List<String>>>)handler));
    }

    private DnsClient __resolveSRV(String name, final Handler<AsyncResult<List<SrvRecord>>> handler) {
        this.delegate.resolveSRV(name, new Handler<AsyncResult<List<io.vertx.core.dns.SrvRecord>>>(){

            @Override
            public void handle(AsyncResult<List<io.vertx.core.dns.SrvRecord>> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(ar.result().stream().map(elt -> SrvRecord.newInstance(elt)).collect(Collectors.toList())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public CompletionStage<List<SrvRecord>> resolveSRV(String name) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__resolveSRV(name, (Handler<AsyncResult<List<SrvRecord>>>)handler));
    }

    private DnsClient __reverseLookup(String ipaddress, Handler<AsyncResult<String>> handler) {
        this.delegate.reverseLookup(ipaddress, handler);
        return this;
    }

    public CompletionStage<String> reverseLookup(String ipaddress) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__reverseLookup(ipaddress, (Handler<AsyncResult<String>>)handler));
    }

    public static DnsClient newInstance(io.vertx.core.dns.DnsClient arg) {
        return arg != null ? new DnsClient(arg) : null;
    }
}

