/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.runtime;

import io.vertx.axle.core.eventbus.EventBus;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Vertx;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.BeforeDestroyed;
import javax.enterprise.context.spi.Context;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Singleton;
import org.jboss.logging.Logger;

@ApplicationScoped
public class VertxProducer {
    private static final Logger LOGGER = Logger.getLogger(VertxProducer.class);

    @Singleton
    @Produces
    public io.vertx.core.eventbus.EventBus eventbus(Vertx vertx) {
        return vertx.eventBus();
    }

    @Singleton
    @Produces
    public io.vertx.mutiny.core.Vertx mutiny(Vertx vertx) {
        return io.vertx.mutiny.core.Vertx.newInstance(vertx);
    }

    @Singleton
    @Produces
    @Deprecated
    public io.vertx.axle.core.Vertx axle(Vertx vertx) {
        LOGGER.warn("`io.vertx.axle.core.Vertx` is deprecated and will be removed in a future version - it is recommended to switch to `io.vertx.mutiny.core.Vertx`");
        return io.vertx.axle.core.Vertx.newInstance(vertx);
    }

    @Singleton
    @Produces
    @Deprecated
    public io.vertx.reactivex.core.Vertx rx(Vertx vertx) {
        LOGGER.warn("`io.vertx.reactivex.core.Vertx` is deprecated  and will be removed in a future version - it is recommended to switch to `io.vertx.mutiny.core.Vertx`");
        return io.vertx.reactivex.core.Vertx.newInstance(vertx);
    }

    @Singleton
    @Produces
    @Deprecated
    public EventBus axleEventBus(io.vertx.axle.core.Vertx axle) {
        LOGGER.warn("`io.vertx.axle.core.eventbus.EventBus` is deprecated and will be removed in a future version - it is recommended to switch to `io.vertx.mutiny.core.eventbus.EventBus`");
        return axle.eventBus();
    }

    @Singleton
    @Produces
    @Deprecated
    public io.vertx.reactivex.core.eventbus.EventBus rxEventBus(io.vertx.reactivex.core.Vertx rx) {
        LOGGER.warn("`io.vertx.reactivex.core.eventbus.EventBus` is deprecated and will be removed in a future version - it is recommended to switch to `io.vertx.mutiny.core.eventbus.EventBus`");
        return rx.eventBus();
    }

    @Singleton
    @Produces
    public io.vertx.mutiny.core.eventbus.EventBus mutinyEventBus(io.vertx.mutiny.core.Vertx mutiny) {
        return mutiny.eventBus();
    }

    void undeployVerticles(@Observes @BeforeDestroyed(value=ApplicationScoped.class) Object event, BeanManager beanManager) {
        Set<Bean<?>> beans = beanManager.getBeans((Type)((Object)AbstractVerticle.class), Any.Literal.INSTANCE);
        Context applicationContext = beanManager.getContext(ApplicationScoped.class);
        for (Bean<?> bean : beans) {
            Object instance;
            if (!ApplicationScoped.class.equals(bean.getScope()) || (instance = applicationContext.get(bean)) == null) continue;
            try {
                AbstractVerticle verticle = (AbstractVerticle)instance;
                io.vertx.mutiny.core.Vertx mutiny = (io.vertx.mutiny.core.Vertx)beanManager.createInstance().select(io.vertx.mutiny.core.Vertx.class, new Annotation[0]).get();
                mutiny.undeploy(verticle.deploymentID()).await().indefinitely();
                LOGGER.debugf("Undeployed verticle: %s", (Object)instance.getClass());
            }
            catch (Exception e) {
                LOGGER.debugf("Unable to undeploy verticle %s: %s", (Object)instance.getClass(), (Object)e.toString());
            }
        }
    }
}

