/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.web.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.impl.LazyValue;
import io.quarkus.security.identity.SecurityIdentity;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import javax.enterprise.event.Event;

public final class RouteHandlers {
    static final String CONTENT_TYPE = "content-type";
    private static final LazyValue<Event<SecurityIdentity>> SECURITY_IDENTITY_EVENT = new LazyValue<Event>(RouteHandlers::createEvent);

    private RouteHandlers() {
    }

    public static void setContentType(final RoutingContext context, final String defaultContentType) {
        final HttpServerResponse response = context.response();
        context.addHeadersEndHandler(new Handler<Void>(){

            @Override
            public void handle(Void aVoid) {
                if (response.headers().get(RouteHandlers.CONTENT_TYPE) == null) {
                    String acceptableContentType = context.getAcceptableContentType();
                    if (acceptableContentType != null) {
                        response.putHeader(RouteHandlers.CONTENT_TYPE, acceptableContentType);
                    } else if (defaultContentType != null) {
                        response.putHeader(RouteHandlers.CONTENT_TYPE, defaultContentType);
                    }
                }
            }
        });
    }

    static void fireSecurityIdentity(SecurityIdentity identity) {
        SECURITY_IDENTITY_EVENT.get().fire(identity);
    }

    static void clear() {
        SECURITY_IDENTITY_EVENT.clear();
    }

    private static Event<SecurityIdentity> createEvent() {
        return Arc.container().beanManager().getEvent().select(SecurityIdentity.class, new Annotation[0]);
    }
}

