/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.common.AbstractConfigSource;
import io.smallrye.config.common.utils.ConfigSourceUtil;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;

class SysPropConfigSource
extends AbstractConfigSource {
    private static final long serialVersionUID = 9167738611308785403L;

    SysPropConfigSource() {
        super("SysPropConfigSource", 400);
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(ConfigSourceUtil.propertiesToMap(AccessController.doPrivileged(System::getProperties)));
    }

    @Override
    public String getValue(String s) {
        return AccessController.doPrivileged(() -> System.getProperty(s));
    }
}

