/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal;

import java.util.ArrayDeque;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.eclipse.yasson.internal.ClassParser;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.model.ClassModel;
import org.eclipse.yasson.internal.model.JsonbAnnotatedElement;
import org.eclipse.yasson.internal.model.customization.ClassCustomization;
import org.eclipse.yasson.internal.serializer.ContainerSerializerProvider;
import org.eclipse.yasson.internal.serializer.DefaultSerializers;

public class MappingContext {
    private final JsonbContext jsonbContext;
    private final ConcurrentHashMap<Class<?>, ClassModel> classes = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<?>, ContainerSerializerProvider> serializers = new ConcurrentHashMap();
    private final ClassParser classParser;

    public MappingContext(JsonbContext jsonbContext) {
        Objects.requireNonNull(jsonbContext);
        this.jsonbContext = jsonbContext;
        this.classParser = new ClassParser(jsonbContext);
    }

    public ClassModel getOrCreateClassModel(Class<?> clazz) {
        ClassModel classModel = this.classes.get(clazz);
        if (classModel != null) {
            return classModel;
        }
        ArrayDeque newClassModels = new ArrayDeque();
        for (Class<?> classToParse = clazz; classToParse != Object.class && classToParse != null; classToParse = classToParse.getSuperclass()) {
            newClassModels.push(classToParse);
        }
        if (clazz == Object.class) {
            return this.classes.computeIfAbsent(clazz, c -> new ClassModel((Class<?>)c, null, null, null));
        }
        ClassModel parentClassModel = null;
        while (!newClassModels.isEmpty()) {
            Class toParse = (Class)newClassModels.pop();
            parentClassModel = this.classes.computeIfAbsent(toParse, MappingContext.createParseClassModelFunction(parentClassModel, this.classParser, this.jsonbContext));
        }
        return this.classes.get(clazz);
    }

    private static Function<Class<?>, ClassModel> createParseClassModelFunction(ClassModel parentClassModel, ClassParser classParser, JsonbContext jsonbContext) {
        return aClass -> {
            JsonbAnnotatedElement<Class<?>> clsElement = jsonbContext.getAnnotationIntrospector().collectAnnotations((Class<?>)aClass);
            ClassCustomization customization = jsonbContext.getAnnotationIntrospector().introspectCustomization(clsElement);
            ClassModel newClassModel = new ClassModel((Class<?>)aClass, customization, parentClassModel, jsonbContext.getConfigProperties().getPropertyNamingStrategy());
            if (!DefaultSerializers.getInstance().isKnownType((Class<?>)aClass)) {
                classParser.parseProperties(newClassModel, clsElement);
            }
            return newClassModel;
        };
    }

    public ClassModel getClassModel(Class<?> clazz) {
        return this.classes.get(clazz);
    }

    public ContainerSerializerProvider getSerializerProvider(Class<?> clazz) {
        return this.serializers.get(clazz);
    }

    public void addSerializerProvider(Class<?> clazz, ContainerSerializerProvider serializerProvider) {
        this.serializers.putIfAbsent(clazz, serializerProvider);
    }
}

