/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.Experimental;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniMemoizeOp;
import java.time.Duration;
import java.util.function.BooleanSupplier;

@Experimental(value="Memoization is an experimental feature at this stage")
public class UniMemoize<T> {
    private final Uni<T> upstream;

    public UniMemoize(AbstractUni<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public Uni<T> until(BooleanSupplier invalidationGuard) {
        BooleanSupplier actual = ParameterValidation.nonNull(invalidationGuard, "invalidationGuard");
        return Infrastructure.onUniCreation(new UniMemoizeOp<T>(this.upstream, actual));
    }

    public Uni<T> atLeast(Duration duration) {
        final Duration validatedDuration = ParameterValidation.validate(duration, "duration");
        return this.until(new BooleanSupplier(){
            private volatile long startTime = -1L;

            @Override
            public boolean getAsBoolean() {
                boolean invalidates;
                long now = System.nanoTime();
                if (this.startTime == -1L) {
                    this.startTime = now;
                }
                boolean bl = invalidates = now - this.startTime > validatedDuration.toNanos();
                if (invalidates) {
                    this.startTime = now;
                }
                return invalidates;
            }
        });
    }

    public Uni<T> indefinitely() {
        return this.until(() -> false);
    }
}

