/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniDelegatingSubscriber;
import io.smallrye.mutiny.operators.UniOnItemTransformToUni;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.function.BiFunction;

public class UniOnItemOrFailureFlatMap<I, O>
extends UniOperator<I, O> {
    private final BiFunction<? super I, Throwable, Uni<? extends O>> mapper;

    public UniOnItemOrFailureFlatMap(Uni<I> upstream, BiFunction<? super I, Throwable, Uni<? extends O>> mapper) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.mapper = ParameterValidation.nonNull(mapper, "mapper");
    }

    public static <I, O> void invokeAndSubstitute(BiFunction<? super I, Throwable, Uni<? extends O>> mapper, I item, Throwable failure, UniSubscriber<? super O> subscriber, UniOnItemTransformToUni.FlatMapSubscription flatMapSubscription) {
        Uni<? extends O> outcome;
        try {
            outcome = mapper.apply(item, failure);
        }
        catch (Throwable e) {
            if (failure != null) {
                subscriber.onFailure(new CompositeException(failure, e));
            } else {
                subscriber.onFailure(e);
            }
            return;
        }
        UniOnItemTransformToUni.handleInnerSubscription(subscriber, flatMapSubscription, outcome);
    }

    @Override
    protected void subscribing(final UniSubscriber<? super O> subscriber) {
        final UniOnItemTransformToUni.FlatMapSubscription flatMapSubscription = new UniOnItemTransformToUni.FlatMapSubscription();
        AbstractUni.subscribe(this.upstream(), new UniDelegatingSubscriber<I, O>(subscriber){

            @Override
            public void onSubscribe(UniSubscription subscription) {
                flatMapSubscription.setInitialUpstream(subscription);
                subscriber.onSubscribe(flatMapSubscription);
            }

            @Override
            public void onItem(I item) {
                UniOnItemOrFailureFlatMap.invokeAndSubstitute(UniOnItemOrFailureFlatMap.this.mapper, item, null, subscriber, flatMapSubscription);
            }

            @Override
            public void onFailure(Throwable failure) {
                UniOnItemOrFailureFlatMap.invokeAndSubstitute(UniOnItemOrFailureFlatMap.this.mapper, null, failure, subscriber, flatMapSubscription);
            }
        });
    }
}

