/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;

public final class MultiDistinctUntilChangedOp<T>
extends AbstractMultiOperator<T, T> {
    public MultiDistinctUntilChangedOp(Multi<? extends T> upstream) {
        super(upstream);
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> actual) {
        this.upstream.subscribe().withSubscriber(new DistinctProcessor<T>(actual));
    }

    static final class DistinctProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        private T last;

        DistinctProcessor(MultiSubscriber<? super T> downstream) {
            super(downstream);
        }

        @Override
        public void onItem(T t) {
            if (this.isDone()) {
                return;
            }
            if (this.last == null || !this.last.equals(t)) {
                this.last = t;
                this.downstream.onItem(t);
            } else {
                this.request(1L);
            }
        }

        @Override
        public void onFailure(Throwable t) {
            super.onFailure(t);
            this.last = null;
        }

        @Override
        public void onCompletion() {
            super.onCompletion();
            this.last = null;
        }

        @Override
        public void cancel() {
            super.cancel();
            this.last = null;
        }
    }
}

