/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.context.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.context.SmallRyeContextManager;
import io.smallrye.context.SmallRyeContextManagerProvider;
import io.smallrye.context.SmallRyeManagedExecutor;
import io.smallrye.context.SmallRyeThreadContext;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.eclipse.microprofile.context.ThreadContext;
import org.eclipse.microprofile.context.spi.ContextManagerExtension;
import org.eclipse.microprofile.context.spi.ContextManagerProvider;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;

@Recorder
public class SmallRyeContextPropagationRecorder {
    private static SmallRyeContextManager.Builder builder;

    public void configureStaticInit(List<ThreadContextProvider> discoveredProviders, List<ContextManagerExtension> discoveredExtensions) {
        if (ContextManagerProvider.INSTANCE.get() == null) {
            SmallRyeContextManagerProvider contextManagerProvider = new SmallRyeContextManagerProvider();
            ContextManagerProvider.register(contextManagerProvider);
        }
        builder = (SmallRyeContextManager.Builder)ContextManagerProvider.instance().getContextManagerBuilder();
        builder.withThreadContextProviders(discoveredProviders.toArray(new ThreadContextProvider[0]));
        builder.withContextManagerExtensions(discoveredExtensions.toArray(new ContextManagerExtension[0]));
    }

    public void configureRuntime(ExecutorService executorService, ShutdownContext shutdownContext) {
        final ContextManagerProvider contextManagerProvider = ContextManagerProvider.instance();
        builder.withDefaultExecutorService(executorService);
        final SmallRyeContextManager contextManager = builder.build();
        contextManagerProvider.registerContextManager(contextManager, Thread.currentThread().getContextClassLoader());
        shutdownContext.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                contextManagerProvider.releaseContextManager(contextManager);
            }
        });
    }

    public Supplier<Object> initializeManagedExecutor(final ExecutorService executorService) {
        return new Supplier<Object>(){

            @Override
            public Object get() {
                ThreadContext threadContext = Arc.container().instance(ThreadContext.class, new Annotation[0]).get();
                return new SmallRyeManagedExecutor(-1, -1, (SmallRyeThreadContext)threadContext, executorService, "no-ip"){

                    @Override
                    public void shutdown() {
                        throw new IllegalStateException("This executor is managed by the container and cannot be shut down.");
                    }

                    @Override
                    public List<Runnable> shutdownNow() {
                        throw new IllegalStateException("This executor is managed by the container and cannot be shut down.");
                    }
                };
            }
        };
    }
}

