/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.runtime.devmode;

import io.quarkus.arc.Arc;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.qute.Engine;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.function.BiFunction;

@Recorder
public class QuteDevConsoleRecorder {
    public static final String RENDER_HANDLER = QuteDevConsoleRecorder.class.getName() + ".RENDER_HANDLER";

    public void setupRenderer() {
        final ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        DevConsoleManager.setGlobal(RENDER_HANDLER, new BiFunction<String, Object, String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String apply(String template, Object data) {
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(tccl);
                    Engine engine = Arc.container().instance(Engine.class, new Annotation[0]).get();
                    String string = engine.getTemplate(template).render(data);
                    return string;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
            }
        });
    }
}

