/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.web.runtime;

import io.quarkus.vertx.http.runtime.HttpCompression;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import java.util.Set;

public class HttpCompressionHandler
implements Handler<RoutingContext> {
    private final Handler<RoutingContext> routeHandler;
    private final HttpCompression compression;
    private final Set<String> compressedMediaTypes;

    public HttpCompressionHandler(Handler<RoutingContext> routeHandler, HttpCompression compression, Set<String> compressedMediaTypes) {
        this.routeHandler = routeHandler;
        this.compression = compression;
        this.compressedMediaTypes = compressedMediaTypes;
    }

    @Override
    public void handle(final RoutingContext context) {
        context.addEndHandler(new Handler<AsyncResult<Void>>(){

            @Override
            public void handle(AsyncResult<Void> result) {
                MultiMap headers;
                String contentEncoding;
                if (result.succeeded() && (contentEncoding = (headers = context.response().headers()).get(HttpHeaders.CONTENT_ENCODING)) != null && HttpHeaders.IDENTITY.toString().equals(contentEncoding)) {
                    switch (HttpCompressionHandler.this.compression) {
                        case ON: {
                            headers.remove(HttpHeaders.CONTENT_ENCODING);
                            break;
                        }
                        case UNDEFINED: {
                            String contentType = headers.get(HttpHeaders.CONTENT_TYPE);
                            int paramIndex = contentType.indexOf(59);
                            if (paramIndex > -1) {
                                contentType = contentType.substring(0, paramIndex);
                            }
                            if (contentType == null || !HttpCompressionHandler.this.compressedMediaTypes.contains(contentType)) break;
                            headers.remove(HttpHeaders.CONTENT_ENCODING);
                            break;
                        }
                    }
                }
            }
        });
        this.routeHandler.handle(context);
    }
}

