/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.security.credential.TokenCredential;
import io.smallrye.jwt.auth.principal.DefaultJWTCallerPrincipal;
import java.util.Optional;
import org.jose4j.jwt.JwtClaims;

public class OidcJwtCallerPrincipal
extends DefaultJWTCallerPrincipal {
    private final JwtClaims claims;
    private final String principalClaim;
    private final TokenCredential credential;

    public OidcJwtCallerPrincipal(JwtClaims claims, TokenCredential credential) {
        this(claims, credential, null);
    }

    public OidcJwtCallerPrincipal(JwtClaims claims, TokenCredential credential, String principalClaim) {
        super(claims);
        this.claims = claims;
        this.credential = credential;
        this.principalClaim = principalClaim;
    }

    public JwtClaims getClaims() {
        return this.claims;
    }

    public TokenCredential getCredential() {
        return this.credential;
    }

    @Override
    public String getName() {
        if (this.principalClaim != null) {
            Optional<Object> claim = super.claim(this.principalClaim);
            return claim.orElse(null);
        }
        return super.getName();
    }
}

