/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime;

import io.quarkus.resteasy.runtime.standalone.QuarkusResteasySecurityContext;
import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.smallrye.mutiny.Uni;
import java.io.IOException;
import java.security.Permission;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.plugins.server.servlet.ServletSecurityContext;

@PreMatching
@Priority(value=5001)
@Provider
public class SecurityContextFilter
implements ContainerRequestFilter {
    @Inject
    SecurityIdentity old;
    @Inject
    CurrentIdentityAssociation currentIdentityAssociation;

    @Override
    public void filter(ContainerRequestContext requestContext) throws IOException {
        final SecurityContext modified = requestContext.getSecurityContext();
        if (modified instanceof ServletSecurityContext || modified instanceof QuarkusResteasySecurityContext) {
            return;
        }
        final Set<Credential> oldCredentials = this.old.getCredentials();
        final Map<String, Object> oldAttributes = this.old.getAttributes();
        SecurityIdentity newIdentity = new SecurityIdentity(){

            @Override
            public Principal getPrincipal() {
                return modified.getUserPrincipal();
            }

            @Override
            public boolean isAnonymous() {
                return modified.getUserPrincipal() == null;
            }

            @Override
            public Set<String> getRoles() {
                throw new UnsupportedOperationException("retrieving all roles not supported when JAX-RS security context has been replaced");
            }

            @Override
            public boolean hasRole(String role) {
                return modified.isUserInRole(role);
            }

            @Override
            public <T extends Credential> T getCredential(Class<T> credentialType) {
                for (Credential cred : this.getCredentials()) {
                    if (!credentialType.isAssignableFrom(cred.getClass())) continue;
                    return (T)cred;
                }
                return null;
            }

            @Override
            public Set<Credential> getCredentials() {
                return oldCredentials;
            }

            @Override
            public <T> T getAttribute(String name) {
                return (T)oldAttributes.get(name);
            }

            @Override
            public Map<String, Object> getAttributes() {
                return oldAttributes;
            }

            @Override
            public Uni<Boolean> checkPermission(Permission permission) {
                return Uni.createFrom().nullItem();
            }
        };
        this.currentIdentityAssociation.setIdentity(newIdentity);
    }
}

