/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime.standalone;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import java.io.IOException;
import org.jboss.logging.Logger;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.core.ThreadLocalResteasyProviderFactory;
import org.jboss.resteasy.plugins.server.embedded.SecurityDomain;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class RequestDispatcher {
    private static final Logger log = Logger.getLogger("io.quarkus.resteasy");
    protected final SynchronousDispatcher dispatcher;
    protected final ResteasyProviderFactory providerFactory;
    protected final SecurityDomain domain;
    protected final ClassLoader classLoader;

    public RequestDispatcher(SynchronousDispatcher dispatcher, ResteasyProviderFactory providerFactory, SecurityDomain domain, ClassLoader classLoader) {
        this.dispatcher = dispatcher;
        this.providerFactory = providerFactory;
        this.domain = domain;
        this.classLoader = classLoader;
    }

    public SynchronousDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public SecurityDomain getDomain() {
        return this.domain;
    }

    public ResteasyProviderFactory getProviderFactory() {
        return this.providerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Context context, HttpServerRequest req, HttpServerResponse resp, HttpRequest vertxReq, HttpResponse vertxResp, boolean handleNotFound) throws IOException {
        ResteasyProviderFactory defaultInstance;
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            defaultInstance = ResteasyProviderFactory.getInstance();
            if (defaultInstance instanceof ThreadLocalResteasyProviderFactory) {
                ThreadLocalResteasyProviderFactory.push(this.providerFactory);
            }
            try {
                ResteasyContext.pushContext(Context.class, context);
                ResteasyContext.pushContext(HttpServerRequest.class, req);
                ResteasyContext.pushContext(HttpServerResponse.class, resp);
                ResteasyContext.pushContext(Vertx.class, context.owner());
                if (handleNotFound) {
                    this.dispatcher.invoke(vertxReq, vertxResp);
                } else {
                    this.dispatcher.invokePropagateNotFound(vertxReq, vertxResp);
                }
            }
            finally {
                ResteasyContext.clearContextData();
            }
        }
        finally {
            try {
                defaultInstance = ResteasyProviderFactory.getInstance();
                if (defaultInstance instanceof ThreadLocalResteasyProviderFactory) {
                    ThreadLocalResteasyProviderFactory.pop();
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }
}

