/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.streams.utils;

import io.smallrye.mutiny.helpers.StrictMultiSubscriber;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.streams.utils.WrappedSubscription;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class WrappedSubscriber<T>
implements Subscriber<T> {
    private final CompletableFuture<Void> future = Infrastructure.wrapCompletableFuture(new CompletableFuture());
    private final Subscriber<T> source;
    private final AtomicBoolean subscribed = new AtomicBoolean(false);

    public WrappedSubscriber(Subscriber<T> delegate) {
        this.source = new StrictMultiSubscriber<T>(delegate);
    }

    public CompletionStage<Void> future() {
        return this.future;
    }

    @Override
    public void onSubscribe(Subscription subscription) {
        Objects.requireNonNull(subscription);
        if (this.subscribed.compareAndSet(false, true)) {
            this.source.onSubscribe(new WrappedSubscription(subscription, () -> this.future.completeExceptionally(new CancellationException())));
        } else {
            subscription.cancel();
        }
    }

    @Override
    public void onNext(T item) {
        this.source.onNext(Objects.requireNonNull(item));
    }

    @Override
    public void onError(Throwable throwable) {
        this.future.completeExceptionally(Objects.requireNonNull(throwable));
        this.source.onError(throwable);
    }

    @Override
    public void onComplete() {
        this.future.complete(null);
        this.source.onComplete();
    }
}

