/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.ByteArrayDeserializer;
import io.vertx.core.json.ByteArraySerializer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.EncodeException;
import io.vertx.core.json.InstantDeserializer;
import io.vertx.core.json.InstantSerializer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonArraySerializer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonObjectSerializer;
import io.vertx.core.json.jackson.JacksonCodec;
import io.vertx.core.spi.json.JsonCodec;
import java.time.Instant;

public class Json {
    @Deprecated
    public static ObjectMapper mapper = new ObjectMapper();
    @Deprecated
    public static ObjectMapper prettyMapper = new ObjectMapper();

    private static void initialize() {
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        prettyMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        prettyMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        SimpleModule module = new SimpleModule();
        module.addSerializer(JsonObject.class, new JsonObjectSerializer());
        module.addSerializer(JsonArray.class, new JsonArraySerializer());
        module.addSerializer(Instant.class, new InstantSerializer());
        module.addDeserializer(Instant.class, new InstantDeserializer());
        module.addSerializer(byte[].class, new ByteArraySerializer());
        module.addDeserializer(byte[].class, new ByteArrayDeserializer());
        mapper.registerModule(module);
        prettyMapper.registerModule(module);
    }

    public static String encode(Object obj) throws EncodeException {
        return JsonCodec.INSTANCE.toString(obj);
    }

    public static Buffer encodeToBuffer(Object obj) throws EncodeException {
        return JsonCodec.INSTANCE.toBuffer(obj);
    }

    public static String encodePrettily(Object obj) throws EncodeException {
        return JsonCodec.INSTANCE.toString(obj, true);
    }

    public static <T> T decodeValue(String str, Class<T> clazz) throws DecodeException {
        return JsonCodec.INSTANCE.fromString(str, clazz);
    }

    public static Object decodeValue(String str) throws DecodeException {
        return Json.decodeValue(str, Object.class);
    }

    @Deprecated
    public static <T> T decodeValue(String str, TypeReference<T> type) throws DecodeException {
        return JacksonCodec.fromString(str, type);
    }

    public static Object decodeValue(Buffer buf) throws DecodeException {
        return Json.decodeValue(buf, Object.class);
    }

    @Deprecated
    public static <T> T decodeValue(Buffer buf, TypeReference<T> type) throws DecodeException {
        return JacksonCodec.fromBuffer(buf, type);
    }

    public static <T> T decodeValue(Buffer buf, Class<T> clazz) throws DecodeException {
        return JsonCodec.INSTANCE.fromBuffer(buf, clazz);
    }

    static {
        Json.initialize();
    }
}

