/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.ssl.SniCompletionEvent;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;

public class SslHandshakeCompletionHandler
extends ChannelInboundHandlerAdapter {
    static AttributeKey<String> SERVER_NAME_ATTR = AttributeKey.valueOf("sniServerName");
    private final Handler<AsyncResult<Channel>> handler;

    public SslHandshakeCompletionHandler(Handler<AsyncResult<Channel>> handler) {
        this.handler = handler;
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof SniCompletionEvent) {
            SniCompletionEvent completion = (SniCompletionEvent)evt;
            Attribute<String> val = ctx.channel().attr(SERVER_NAME_ATTR);
            val.set(completion.hostname());
        } else if (evt instanceof SslHandshakeCompletionEvent) {
            SslHandshakeCompletionEvent completion = (SslHandshakeCompletionEvent)evt;
            if (completion.isSuccess()) {
                ctx.pipeline().remove(this);
                this.handler.handle(Future.succeededFuture(ctx.channel()));
            } else {
                this.handler.handle(Future.failedFuture(completion.cause()));
            }
        } else {
            ctx.fireUserEventTriggered(evt);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
    }
}

