/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.file;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.file.CopyOptions;
import io.vertx.core.file.OpenOptions;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.core.file.AsyncFile;
import io.vertx.mutiny.core.file.FileProps;
import io.vertx.mutiny.core.file.FileSystemProps;
import java.util.List;

@MutinyGen(value=io.vertx.core.file.FileSystem.class)
public class FileSystem {
    public static final TypeArg<FileSystem> __TYPE_ARG = new TypeArg<FileSystem>(obj -> new FileSystem((io.vertx.core.file.FileSystem)obj), FileSystem::getDelegate);
    private final io.vertx.core.file.FileSystem delegate;

    public FileSystem(io.vertx.core.file.FileSystem delegate) {
        this.delegate = delegate;
    }

    FileSystem() {
        this.delegate = null;
    }

    public io.vertx.core.file.FileSystem getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSystem that = (FileSystem)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    private FileSystem __copy(String from, String to, Handler<AsyncResult<Void>> handler) {
        this.delegate.copy(from, to, handler);
        return this;
    }

    public Uni<Void> copy(String from, String to) {
        return AsyncResultUni.toUni(handler -> this.__copy(from, to, (Handler<AsyncResult<Void>>)handler));
    }

    public Void copyAndAwait(String from, String to) {
        return this.copy(from, to).await().indefinitely();
    }

    private FileSystem __copy(String from, String to, CopyOptions options, Handler<AsyncResult<Void>> handler) {
        this.delegate.copy(from, to, options, handler);
        return this;
    }

    public Uni<Void> copy(String from, String to, CopyOptions options) {
        return AsyncResultUni.toUni(handler -> this.__copy(from, to, options, (Handler<AsyncResult<Void>>)handler));
    }

    public Void copyAndAwait(String from, String to, CopyOptions options) {
        return this.copy(from, to, options).await().indefinitely();
    }

    public FileSystem copyBlocking(String from, String to) {
        this.delegate.copyBlocking(from, to);
        return this;
    }

    private FileSystem __copyRecursive(String from, String to, boolean recursive, Handler<AsyncResult<Void>> handler) {
        this.delegate.copyRecursive(from, to, recursive, handler);
        return this;
    }

    public Uni<Void> copyRecursive(String from, String to, boolean recursive) {
        return AsyncResultUni.toUni(handler -> this.__copyRecursive(from, to, recursive, (Handler<AsyncResult<Void>>)handler));
    }

    public Void copyRecursiveAndAwait(String from, String to, boolean recursive) {
        return this.copyRecursive(from, to, recursive).await().indefinitely();
    }

    public FileSystem copyRecursiveBlocking(String from, String to, boolean recursive) {
        this.delegate.copyRecursiveBlocking(from, to, recursive);
        return this;
    }

    private FileSystem __move(String from, String to, Handler<AsyncResult<Void>> handler) {
        this.delegate.move(from, to, handler);
        return this;
    }

    public Uni<Void> move(String from, String to) {
        return AsyncResultUni.toUni(handler -> this.__move(from, to, (Handler<AsyncResult<Void>>)handler));
    }

    public Void moveAndAwait(String from, String to) {
        return this.move(from, to).await().indefinitely();
    }

    private FileSystem __move(String from, String to, CopyOptions options, Handler<AsyncResult<Void>> handler) {
        this.delegate.move(from, to, options, handler);
        return this;
    }

    public Uni<Void> move(String from, String to, CopyOptions options) {
        return AsyncResultUni.toUni(handler -> this.__move(from, to, options, (Handler<AsyncResult<Void>>)handler));
    }

    public Void moveAndAwait(String from, String to, CopyOptions options) {
        return this.move(from, to, options).await().indefinitely();
    }

    public FileSystem moveBlocking(String from, String to) {
        this.delegate.moveBlocking(from, to);
        return this;
    }

    private FileSystem __truncate(String path, long len, Handler<AsyncResult<Void>> handler) {
        this.delegate.truncate(path, len, handler);
        return this;
    }

    public Uni<Void> truncate(String path, long len) {
        return AsyncResultUni.toUni(handler -> this.__truncate(path, len, (Handler<AsyncResult<Void>>)handler));
    }

    public Void truncateAndAwait(String path, long len) {
        return this.truncate(path, len).await().indefinitely();
    }

    public FileSystem truncateBlocking(String path, long len) {
        this.delegate.truncateBlocking(path, len);
        return this;
    }

    private FileSystem __chmod(String path, String perms, Handler<AsyncResult<Void>> handler) {
        this.delegate.chmod(path, perms, handler);
        return this;
    }

    public Uni<Void> chmod(String path, String perms) {
        return AsyncResultUni.toUni(handler -> this.__chmod(path, perms, (Handler<AsyncResult<Void>>)handler));
    }

    public Void chmodAndAwait(String path, String perms) {
        return this.chmod(path, perms).await().indefinitely();
    }

    public FileSystem chmodBlocking(String path, String perms) {
        this.delegate.chmodBlocking(path, perms);
        return this;
    }

    private FileSystem __chmodRecursive(String path, String perms, String dirPerms, Handler<AsyncResult<Void>> handler) {
        this.delegate.chmodRecursive(path, perms, dirPerms, handler);
        return this;
    }

    public Uni<Void> chmodRecursive(String path, String perms, String dirPerms) {
        return AsyncResultUni.toUni(handler -> this.__chmodRecursive(path, perms, dirPerms, (Handler<AsyncResult<Void>>)handler));
    }

    public Void chmodRecursiveAndAwait(String path, String perms, String dirPerms) {
        return this.chmodRecursive(path, perms, dirPerms).await().indefinitely();
    }

    public FileSystem chmodRecursiveBlocking(String path, String perms, String dirPerms) {
        this.delegate.chmodRecursiveBlocking(path, perms, dirPerms);
        return this;
    }

    private FileSystem __chown(String path, String user, String group, Handler<AsyncResult<Void>> handler) {
        this.delegate.chown(path, user, group, handler);
        return this;
    }

    public Uni<Void> chown(String path, String user, String group) {
        return AsyncResultUni.toUni(handler -> this.__chown(path, user, group, (Handler<AsyncResult<Void>>)handler));
    }

    public Void chownAndAwait(String path, String user, String group) {
        return this.chown(path, user, group).await().indefinitely();
    }

    public FileSystem chownBlocking(String path, String user, String group) {
        this.delegate.chownBlocking(path, user, group);
        return this;
    }

    private FileSystem __props(String path, final Handler<AsyncResult<FileProps>> handler) {
        this.delegate.props(path, new Handler<AsyncResult<io.vertx.core.file.FileProps>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.file.FileProps> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(FileProps.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<FileProps> props(String path) {
        return AsyncResultUni.toUni(handler -> this.__props(path, (Handler<AsyncResult<FileProps>>)handler));
    }

    public FileProps propsAndAwait(String path) {
        return this.props(path).await().indefinitely();
    }

    public FileProps propsBlocking(String path) {
        FileProps ret = FileProps.newInstance(this.delegate.propsBlocking(path));
        return ret;
    }

    private FileSystem __lprops(String path, final Handler<AsyncResult<FileProps>> handler) {
        this.delegate.lprops(path, new Handler<AsyncResult<io.vertx.core.file.FileProps>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.file.FileProps> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(FileProps.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<FileProps> lprops(String path) {
        return AsyncResultUni.toUni(handler -> this.__lprops(path, (Handler<AsyncResult<FileProps>>)handler));
    }

    public FileProps lpropsAndAwait(String path) {
        return this.lprops(path).await().indefinitely();
    }

    public FileProps lpropsBlocking(String path) {
        FileProps ret = FileProps.newInstance(this.delegate.lpropsBlocking(path));
        return ret;
    }

    private FileSystem __link(String link, String existing, Handler<AsyncResult<Void>> handler) {
        this.delegate.link(link, existing, handler);
        return this;
    }

    public Uni<Void> link(String link, String existing) {
        return AsyncResultUni.toUni(handler -> this.__link(link, existing, (Handler<AsyncResult<Void>>)handler));
    }

    public Void linkAndAwait(String link, String existing) {
        return this.link(link, existing).await().indefinitely();
    }

    public FileSystem linkBlocking(String link, String existing) {
        this.delegate.linkBlocking(link, existing);
        return this;
    }

    private FileSystem __symlink(String link, String existing, Handler<AsyncResult<Void>> handler) {
        this.delegate.symlink(link, existing, handler);
        return this;
    }

    public Uni<Void> symlink(String link, String existing) {
        return AsyncResultUni.toUni(handler -> this.__symlink(link, existing, (Handler<AsyncResult<Void>>)handler));
    }

    public Void symlinkAndAwait(String link, String existing) {
        return this.symlink(link, existing).await().indefinitely();
    }

    public FileSystem symlinkBlocking(String link, String existing) {
        this.delegate.symlinkBlocking(link, existing);
        return this;
    }

    private FileSystem __unlink(String link, Handler<AsyncResult<Void>> handler) {
        this.delegate.unlink(link, handler);
        return this;
    }

    public Uni<Void> unlink(String link) {
        return AsyncResultUni.toUni(handler -> this.__unlink(link, (Handler<AsyncResult<Void>>)handler));
    }

    public Void unlinkAndAwait(String link) {
        return this.unlink(link).await().indefinitely();
    }

    public FileSystem unlinkBlocking(String link) {
        this.delegate.unlinkBlocking(link);
        return this;
    }

    private FileSystem __readSymlink(String link, Handler<AsyncResult<String>> handler) {
        this.delegate.readSymlink(link, handler);
        return this;
    }

    public Uni<String> readSymlink(String link) {
        return AsyncResultUni.toUni(handler -> this.__readSymlink(link, (Handler<AsyncResult<String>>)handler));
    }

    public String readSymlinkAndAwait(String link) {
        return this.readSymlink(link).await().indefinitely();
    }

    public String readSymlinkBlocking(String link) {
        String ret = this.delegate.readSymlinkBlocking(link);
        return ret;
    }

    private FileSystem __delete(String path, Handler<AsyncResult<Void>> handler) {
        this.delegate.delete(path, handler);
        return this;
    }

    public Uni<Void> delete(String path) {
        return AsyncResultUni.toUni(handler -> this.__delete(path, (Handler<AsyncResult<Void>>)handler));
    }

    public Void deleteAndAwait(String path) {
        return this.delete(path).await().indefinitely();
    }

    public FileSystem deleteBlocking(String path) {
        this.delegate.deleteBlocking(path);
        return this;
    }

    private FileSystem __deleteRecursive(String path, boolean recursive, Handler<AsyncResult<Void>> handler) {
        this.delegate.deleteRecursive(path, recursive, handler);
        return this;
    }

    public Uni<Void> deleteRecursive(String path, boolean recursive) {
        return AsyncResultUni.toUni(handler -> this.__deleteRecursive(path, recursive, (Handler<AsyncResult<Void>>)handler));
    }

    public Void deleteRecursiveAndAwait(String path, boolean recursive) {
        return this.deleteRecursive(path, recursive).await().indefinitely();
    }

    public FileSystem deleteRecursiveBlocking(String path, boolean recursive) {
        this.delegate.deleteRecursiveBlocking(path, recursive);
        return this;
    }

    private FileSystem __mkdir(String path, Handler<AsyncResult<Void>> handler) {
        this.delegate.mkdir(path, handler);
        return this;
    }

    public Uni<Void> mkdir(String path) {
        return AsyncResultUni.toUni(handler -> this.__mkdir(path, (Handler<AsyncResult<Void>>)handler));
    }

    public Void mkdirAndAwait(String path) {
        return this.mkdir(path).await().indefinitely();
    }

    public FileSystem mkdirBlocking(String path) {
        this.delegate.mkdirBlocking(path);
        return this;
    }

    private FileSystem __mkdir(String path, String perms, Handler<AsyncResult<Void>> handler) {
        this.delegate.mkdir(path, perms, handler);
        return this;
    }

    public Uni<Void> mkdir(String path, String perms) {
        return AsyncResultUni.toUni(handler -> this.__mkdir(path, perms, (Handler<AsyncResult<Void>>)handler));
    }

    public Void mkdirAndAwait(String path, String perms) {
        return this.mkdir(path, perms).await().indefinitely();
    }

    public FileSystem mkdirBlocking(String path, String perms) {
        this.delegate.mkdirBlocking(path, perms);
        return this;
    }

    private FileSystem __mkdirs(String path, Handler<AsyncResult<Void>> handler) {
        this.delegate.mkdirs(path, handler);
        return this;
    }

    public Uni<Void> mkdirs(String path) {
        return AsyncResultUni.toUni(handler -> this.__mkdirs(path, (Handler<AsyncResult<Void>>)handler));
    }

    public Void mkdirsAndAwait(String path) {
        return this.mkdirs(path).await().indefinitely();
    }

    public FileSystem mkdirsBlocking(String path) {
        this.delegate.mkdirsBlocking(path);
        return this;
    }

    private FileSystem __mkdirs(String path, String perms, Handler<AsyncResult<Void>> handler) {
        this.delegate.mkdirs(path, perms, handler);
        return this;
    }

    public Uni<Void> mkdirs(String path, String perms) {
        return AsyncResultUni.toUni(handler -> this.__mkdirs(path, perms, (Handler<AsyncResult<Void>>)handler));
    }

    public Void mkdirsAndAwait(String path, String perms) {
        return this.mkdirs(path, perms).await().indefinitely();
    }

    public FileSystem mkdirsBlocking(String path, String perms) {
        this.delegate.mkdirsBlocking(path, perms);
        return this;
    }

    private FileSystem __readDir(String path, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.readDir(path, handler);
        return this;
    }

    public Uni<List<String>> readDir(String path) {
        return AsyncResultUni.toUni(handler -> this.__readDir(path, (Handler<AsyncResult<List<String>>>)handler));
    }

    public List<String> readDirAndAwait(String path) {
        return this.readDir(path).await().indefinitely();
    }

    public List<String> readDirBlocking(String path) {
        List<String> ret = this.delegate.readDirBlocking(path);
        return ret;
    }

    private FileSystem __readDir(String path, String filter, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.readDir(path, filter, handler);
        return this;
    }

    public Uni<List<String>> readDir(String path, String filter) {
        return AsyncResultUni.toUni(handler -> this.__readDir(path, filter, (Handler<AsyncResult<List<String>>>)handler));
    }

    public List<String> readDirAndAwait(String path, String filter) {
        return this.readDir(path, filter).await().indefinitely();
    }

    public List<String> readDirBlocking(String path, String filter) {
        List<String> ret = this.delegate.readDirBlocking(path, filter);
        return ret;
    }

    private FileSystem __readFile(String path, final Handler<AsyncResult<Buffer>> handler) {
        this.delegate.readFile(path, new Handler<AsyncResult<io.vertx.core.buffer.Buffer>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.buffer.Buffer> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Buffer.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<Buffer> readFile(String path) {
        return AsyncResultUni.toUni(handler -> this.__readFile(path, (Handler<AsyncResult<Buffer>>)handler));
    }

    public Buffer readFileAndAwait(String path) {
        return this.readFile(path).await().indefinitely();
    }

    public Buffer readFileBlocking(String path) {
        Buffer ret = Buffer.newInstance(this.delegate.readFileBlocking(path));
        return ret;
    }

    private FileSystem __writeFile(String path, Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeFile(path, data.getDelegate(), handler);
        return this;
    }

    public Uni<Void> writeFile(String path, Buffer data) {
        return AsyncResultUni.toUni(handler -> this.__writeFile(path, data, (Handler<AsyncResult<Void>>)handler));
    }

    public Void writeFileAndAwait(String path, Buffer data) {
        return this.writeFile(path, data).await().indefinitely();
    }

    public FileSystem writeFileBlocking(String path, Buffer data) {
        this.delegate.writeFileBlocking(path, data.getDelegate());
        return this;
    }

    private FileSystem __open(String path, OpenOptions options, final Handler<AsyncResult<AsyncFile>> handler) {
        this.delegate.open(path, options, new Handler<AsyncResult<io.vertx.core.file.AsyncFile>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.file.AsyncFile> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(AsyncFile.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<AsyncFile> open(String path, OpenOptions options) {
        return AsyncResultUni.toUni(handler -> this.__open(path, options, (Handler<AsyncResult<AsyncFile>>)handler));
    }

    public AsyncFile openAndAwait(String path, OpenOptions options) {
        return this.open(path, options).await().indefinitely();
    }

    public AsyncFile openBlocking(String path, OpenOptions options) {
        AsyncFile ret = AsyncFile.newInstance(this.delegate.openBlocking(path, options));
        return ret;
    }

    private FileSystem __createFile(String path, Handler<AsyncResult<Void>> handler) {
        this.delegate.createFile(path, handler);
        return this;
    }

    public Uni<Void> createFile(String path) {
        return AsyncResultUni.toUni(handler -> this.__createFile(path, (Handler<AsyncResult<Void>>)handler));
    }

    public Void createFileAndAwait(String path) {
        return this.createFile(path).await().indefinitely();
    }

    public FileSystem createFileBlocking(String path) {
        this.delegate.createFileBlocking(path);
        return this;
    }

    private FileSystem __createFile(String path, String perms, Handler<AsyncResult<Void>> handler) {
        this.delegate.createFile(path, perms, handler);
        return this;
    }

    public Uni<Void> createFile(String path, String perms) {
        return AsyncResultUni.toUni(handler -> this.__createFile(path, perms, (Handler<AsyncResult<Void>>)handler));
    }

    public Void createFileAndAwait(String path, String perms) {
        return this.createFile(path, perms).await().indefinitely();
    }

    public FileSystem createFileBlocking(String path, String perms) {
        this.delegate.createFileBlocking(path, perms);
        return this;
    }

    private FileSystem __exists(String path, Handler<AsyncResult<Boolean>> handler) {
        this.delegate.exists(path, handler);
        return this;
    }

    public Uni<Boolean> exists(String path) {
        return AsyncResultUni.toUni(handler -> this.__exists(path, (Handler<AsyncResult<Boolean>>)handler));
    }

    public Boolean existsAndAwait(String path) {
        return this.exists(path).await().indefinitely();
    }

    public boolean existsBlocking(String path) {
        boolean ret = this.delegate.existsBlocking(path);
        return ret;
    }

    private FileSystem __fsProps(String path, final Handler<AsyncResult<FileSystemProps>> handler) {
        this.delegate.fsProps(path, new Handler<AsyncResult<io.vertx.core.file.FileSystemProps>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.file.FileSystemProps> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(FileSystemProps.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<FileSystemProps> fsProps(String path) {
        return AsyncResultUni.toUni(handler -> this.__fsProps(path, (Handler<AsyncResult<FileSystemProps>>)handler));
    }

    public FileSystemProps fsPropsAndAwait(String path) {
        return this.fsProps(path).await().indefinitely();
    }

    public FileSystemProps fsPropsBlocking(String path) {
        FileSystemProps ret = FileSystemProps.newInstance(this.delegate.fsPropsBlocking(path));
        return ret;
    }

    private FileSystem __createTempDirectory(String prefix, Handler<AsyncResult<String>> handler) {
        this.delegate.createTempDirectory(prefix, handler);
        return this;
    }

    public Uni<String> createTempDirectory(String prefix) {
        return AsyncResultUni.toUni(handler -> this.__createTempDirectory(prefix, (Handler<AsyncResult<String>>)handler));
    }

    public String createTempDirectoryAndAwait(String prefix) {
        return this.createTempDirectory(prefix).await().indefinitely();
    }

    public String createTempDirectoryBlocking(String prefix) {
        String ret = this.delegate.createTempDirectoryBlocking(prefix);
        return ret;
    }

    private FileSystem __createTempDirectory(String prefix, String perms, Handler<AsyncResult<String>> handler) {
        this.delegate.createTempDirectory(prefix, perms, handler);
        return this;
    }

    public Uni<String> createTempDirectory(String prefix, String perms) {
        return AsyncResultUni.toUni(handler -> this.__createTempDirectory(prefix, perms, (Handler<AsyncResult<String>>)handler));
    }

    public String createTempDirectoryAndAwait(String prefix, String perms) {
        return this.createTempDirectory(prefix, perms).await().indefinitely();
    }

    public String createTempDirectoryBlocking(String prefix, String perms) {
        String ret = this.delegate.createTempDirectoryBlocking(prefix, perms);
        return ret;
    }

    private FileSystem __createTempDirectory(String dir, String prefix, String perms, Handler<AsyncResult<String>> handler) {
        this.delegate.createTempDirectory(dir, prefix, perms, handler);
        return this;
    }

    public Uni<String> createTempDirectory(String dir, String prefix, String perms) {
        return AsyncResultUni.toUni(handler -> this.__createTempDirectory(dir, prefix, perms, (Handler<AsyncResult<String>>)handler));
    }

    public String createTempDirectoryAndAwait(String dir, String prefix, String perms) {
        return this.createTempDirectory(dir, prefix, perms).await().indefinitely();
    }

    public String createTempDirectoryBlocking(String dir, String prefix, String perms) {
        String ret = this.delegate.createTempDirectoryBlocking(dir, prefix, perms);
        return ret;
    }

    private FileSystem __createTempFile(String prefix, String suffix, Handler<AsyncResult<String>> handler) {
        this.delegate.createTempFile(prefix, suffix, handler);
        return this;
    }

    public Uni<String> createTempFile(String prefix, String suffix) {
        return AsyncResultUni.toUni(handler -> this.__createTempFile(prefix, suffix, (Handler<AsyncResult<String>>)handler));
    }

    public String createTempFileAndAwait(String prefix, String suffix) {
        return this.createTempFile(prefix, suffix).await().indefinitely();
    }

    public String createTempFileBlocking(String prefix, String suffix) {
        String ret = this.delegate.createTempFileBlocking(prefix, suffix);
        return ret;
    }

    private FileSystem __createTempFile(String prefix, String suffix, String perms, Handler<AsyncResult<String>> handler) {
        this.delegate.createTempFile(prefix, suffix, perms, handler);
        return this;
    }

    public Uni<String> createTempFile(String prefix, String suffix, String perms) {
        return AsyncResultUni.toUni(handler -> this.__createTempFile(prefix, suffix, perms, (Handler<AsyncResult<String>>)handler));
    }

    public String createTempFileAndAwait(String prefix, String suffix, String perms) {
        return this.createTempFile(prefix, suffix, perms).await().indefinitely();
    }

    public String createTempFileBlocking(String prefix, String suffix, String perms) {
        String ret = this.delegate.createTempFileBlocking(prefix, suffix, perms);
        return ret;
    }

    private FileSystem __createTempFile(String dir, String prefix, String suffix, String perms, Handler<AsyncResult<String>> handler) {
        this.delegate.createTempFile(dir, prefix, suffix, perms, handler);
        return this;
    }

    public Uni<String> createTempFile(String dir, String prefix, String suffix, String perms) {
        return AsyncResultUni.toUni(handler -> this.__createTempFile(dir, prefix, suffix, perms, (Handler<AsyncResult<String>>)handler));
    }

    public String createTempFileAndAwait(String dir, String prefix, String suffix, String perms) {
        return this.createTempFile(dir, prefix, suffix, perms).await().indefinitely();
    }

    public String createTempFileBlocking(String dir, String prefix, String suffix, String perms) {
        String ret = this.delegate.createTempFileBlocking(dir, prefix, suffix, perms);
        return ret;
    }

    public static FileSystem newInstance(io.vertx.core.file.FileSystem arg) {
        return arg != null ? new FileSystem(arg) : null;
    }
}

