/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.web.handler;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.ext.auth.User;
import io.vertx.reactivex.ext.auth.jwt.JWTAuth;
import io.vertx.reactivex.ext.web.RoutingContext;
import io.vertx.reactivex.ext.web.handler.AuthHandler;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import java.util.List;
import java.util.Set;

@RxGen(value=io.vertx.ext.web.handler.JWTAuthHandler.class)
public class JWTAuthHandler
implements AuthHandler,
Handler<RoutingContext> {
    public static final TypeArg<JWTAuthHandler> __TYPE_ARG = new TypeArg<JWTAuthHandler>(obj -> new JWTAuthHandler((io.vertx.ext.web.handler.JWTAuthHandler)obj), JWTAuthHandler::getDelegate);
    private final io.vertx.ext.web.handler.JWTAuthHandler delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JWTAuthHandler that = (JWTAuthHandler)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public JWTAuthHandler(io.vertx.ext.web.handler.JWTAuthHandler delegate) {
        this.delegate = delegate;
    }

    public JWTAuthHandler(Object delegate) {
        this.delegate = (io.vertx.ext.web.handler.JWTAuthHandler)delegate;
    }

    @Override
    public io.vertx.ext.web.handler.JWTAuthHandler getDelegate() {
        return this.delegate;
    }

    @Override
    public void handle(RoutingContext event) {
        this.delegate.handle(event.getDelegate());
    }

    @Override
    public AuthHandler addAuthority(String authority) {
        this.delegate.addAuthority(authority);
        return this;
    }

    @Override
    public AuthHandler addAuthorities(Set<String> authorities) {
        this.delegate.addAuthorities(authorities);
        return this;
    }

    @Override
    public void parseCredentials(RoutingContext context, Handler<AsyncResult<JsonObject>> handler) {
        this.delegate.parseCredentials(context.getDelegate(), handler);
    }

    public Single<JsonObject> rxParseCredentials(RoutingContext context) {
        return AsyncResultSingle.toSingle(handler -> this.parseCredentials(context, (Handler<AsyncResult<JsonObject>>)handler));
    }

    @Override
    public void authorize(User user, Handler<AsyncResult<Void>> handler) {
        this.delegate.authorize(user.getDelegate(), handler);
    }

    public Completable rxAuthorize(User user) {
        return AsyncResultCompletable.toCompletable(handler -> this.authorize(user, (Handler<AsyncResult<Void>>)handler));
    }

    public static JWTAuthHandler create(JWTAuth authProvider) {
        JWTAuthHandler ret = JWTAuthHandler.newInstance(io.vertx.ext.web.handler.JWTAuthHandler.create(authProvider.getDelegate()));
        return ret;
    }

    public static JWTAuthHandler create(JWTAuth authProvider, String skip) {
        JWTAuthHandler ret = JWTAuthHandler.newInstance(io.vertx.ext.web.handler.JWTAuthHandler.create(authProvider.getDelegate(), skip));
        return ret;
    }

    public JWTAuthHandler setAudience(List<String> audience) {
        this.delegate.setAudience(audience);
        return this;
    }

    public JWTAuthHandler setIssuer(String issuer) {
        this.delegate.setIssuer(issuer);
        return this;
    }

    public JWTAuthHandler setIgnoreExpiration(boolean ignoreExpiration) {
        this.delegate.setIgnoreExpiration(ignoreExpiration);
        return this;
    }

    public static JWTAuthHandler newInstance(io.vertx.ext.web.handler.JWTAuthHandler arg) {
        return arg != null ? new JWTAuthHandler(arg) : null;
    }
}

