/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Engine;
import io.quarkus.qute.Expression;
import io.quarkus.qute.Futures;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.Mapper;
import io.quarkus.qute.Parameter;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;

public class UserTagSectionHelper
implements SectionHelper {
    private static final String IT = "it";
    private static final String NESTED_CONTENT = "nested-content";
    private final Supplier<Template> templateSupplier;
    private final Map<String, Expression> parameters;
    private final boolean isEmpty;

    UserTagSectionHelper(Supplier<Template> templateSupplier, Map<String, Expression> parameters, boolean isEmpty) {
        this.templateSupplier = templateSupplier;
        this.parameters = parameters;
        this.isEmpty = isEmpty;
    }

    @Override
    public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
        CompletableFuture<ResultNode> result = new CompletableFuture<ResultNode>();
        Futures.evaluateParams(this.parameters, context.resolutionContext()).whenComplete((evaluatedParams, t1) -> {
            if (t1 != null) {
                result.completeExceptionally((Throwable)t1);
            } else {
                if (!this.isEmpty) {
                    evaluatedParams.put(NESTED_CONTENT, context.execute(context.resolutionContext().createChild(Mapper.wrap(evaluatedParams), null)));
                }
                try {
                    TemplateImpl tagTemplate = (TemplateImpl)this.templateSupplier.get();
                    tagTemplate.root.resolve(context.resolutionContext().createChild(Mapper.wrap(evaluatedParams), null)).whenComplete((resultNode, t2) -> {
                        if (t2 != null) {
                            result.completeExceptionally((Throwable)t2);
                        } else {
                            result.complete((ResultNode)resultNode);
                        }
                    });
                }
                catch (Throwable e) {
                    result.completeExceptionally(e);
                }
            }
        });
        return result;
    }

    public static class Factory
    implements SectionHelperFactory<UserTagSectionHelper> {
        private final String name;
        private final String templateId;

        public Factory(String name, String templateId) {
            this.name = name;
            this.templateId = templateId;
        }

        @Override
        public List<String> getDefaultAliases() {
            return ImmutableList.of(this.name);
        }

        @Override
        public SectionHelperFactory.ParametersInfo getParameters() {
            return SectionHelperFactory.ParametersInfo.builder().addParameter(new Parameter(UserTagSectionHelper.IT, UserTagSectionHelper.IT, false)).build();
        }

        @Override
        public UserTagSectionHelper initialize(SectionHelperFactory.SectionInitContext context) {
            HashMap<String, Expression> params = new HashMap<String, Expression>();
            for (Map.Entry<String, String> entry : context.getParameters().entrySet()) {
                params.put(entry.getKey(), context.parseValue(entry.getValue()));
            }
            boolean isEmpty = context.getBlocks().size() == 1 && context.getBlocks().get(0).isEmpty();
            final Engine engine = context.getEngine();
            return new UserTagSectionHelper(new Supplier<Template>(){

                @Override
                public Template get() {
                    Template template = engine.getTemplate(templateId);
                    if (template == null) {
                        throw new TemplateException("Tag template not found: " + templateId);
                    }
                    return template;
                }
            }, params, isEmpty);
        }
    }
}

