/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.MemoryAttribute;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerFileUpload;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.impl.HttpServerFileUploadImpl;
import io.vertx.core.http.impl.NettyFileUpload;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.function.Supplier;

class NettyFileUploadDataFactory
extends DefaultHttpDataFactory {
    private final Context context;
    private final HttpServerRequest request;
    private final Supplier<Handler<HttpServerFileUpload>> lazyUploadHandler;
    private final long maxAttributeSize;

    NettyFileUploadDataFactory(Context context, long maxAttributeSize, HttpServerRequest request, Supplier<Handler<HttpServerFileUpload>> lazyUploadHandler) {
        super(false);
        this.context = context;
        this.request = request;
        this.maxAttributeSize = maxAttributeSize;
        this.lazyUploadHandler = lazyUploadHandler;
    }

    @Override
    public Attribute createAttribute(HttpRequest request, String name) {
        return this.createAttribute(request, name, 0L);
    }

    @Override
    public Attribute createAttribute(HttpRequest request, String name, long definedSize) {
        VertxAttribute attribute = new VertxAttribute(name, definedSize);
        attribute.setMaxSize(this.maxAttributeSize);
        return attribute;
    }

    @Override
    public Attribute createAttribute(HttpRequest request, String name, String value) {
        Attribute attr;
        try {
            attr = this.createAttribute(request, name);
            attr.setValue(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return attr;
    }

    @Override
    public FileUpload createFileUpload(HttpRequest httpRequest, String name, String filename, String contentType, String contentTransferEncoding, Charset charset, long size) {
        NettyFileUpload nettyUpload = new NettyFileUpload(this.context, this.request, name, filename, contentType, contentTransferEncoding, charset);
        HttpServerFileUploadImpl upload = new HttpServerFileUploadImpl(this.context, nettyUpload, name, filename, contentType, contentTransferEncoding, charset, size);
        Handler<HttpServerFileUpload> uploadHandler = this.lazyUploadHandler.get();
        if (uploadHandler != null) {
            uploadHandler.handle(upload);
        }
        return nettyUpload;
    }

    private static class VertxAttribute
    extends MemoryAttribute {
        String value;

        public VertxAttribute(String name, long definedSize) {
            super(name, definedSize);
        }

        @Override
        protected void setCompleted() {
            super.setCompleted();
            this.value = super.getValue();
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

