/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision;

import io.cloudevents.CloudEvent;
import io.reactivex.subscribers.TestSubscriber;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.management.GAV;
import org.kie.kogito.cloudevents.CloudEventUtils;
import org.kie.kogito.decision.DecisionModelResource;
import org.kie.kogito.decision.DecisionModelResourcesProvider;
import org.kie.kogito.decision.DecisionModelType;
import org.kie.kogito.tracing.decision.QuarkusModelEventEmitter;
import org.mockito.Mockito;
import org.reactivestreams.Subscriber;

public class QuarkusModelEventEmitterTest {
    @Test
    public void testEmitEvent() {
        TestSubscriber subscriber = new TestSubscriber();
        List<DecisionModelResource> models = Arrays.asList(this.makeModel(), this.makeModel());
        DecisionModelResourcesProvider mockedDecisionModelResourcesProvider = () -> models;
        QuarkusModelEventEmitter eventEmitter = new QuarkusModelEventEmitter(mockedDecisionModelResourcesProvider);
        eventEmitter.getEventPublisher().subscribe((Subscriber)subscriber);
        eventEmitter.publishDecisionModels();
        subscriber.assertValueCount(2);
        String rawCloudEvent1 = (String)subscriber.values().get(0);
        String rawCloudEvent2 = (String)subscriber.values().get(1);
        CloudEvent cloudEvent1 = (CloudEvent)CloudEventUtils.decode((String)rawCloudEvent1).orElseThrow(IllegalStateException::new);
        CloudEvent cloudEvent2 = (CloudEvent)CloudEventUtils.decode((String)rawCloudEvent2).orElseThrow(IllegalStateException::new);
        Assertions.assertEquals((Object)"id", (Object)cloudEvent1.getId());
        Assertions.assertEquals((Object)"id", (Object)cloudEvent2.getId());
    }

    private DecisionModelResource makeModel() {
        DecisionModelResource model = (DecisionModelResource)Mockito.mock(DecisionModelResource.class);
        Mockito.when((Object)model.getGav()).thenReturn((Object)new GAV("groupId", "artifactId", "version"));
        Mockito.when((Object)model.getModelName()).thenReturn((Object)"name");
        Mockito.when((Object)model.getNamespace()).thenReturn((Object)"namespace");
        Mockito.when((Object)model.getModelType()).thenReturn((Object)DecisionModelType.DMN);
        Mockito.when((Object)((String)model.get())).thenReturn((Object)"model");
        return model;
    }
}

