/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEvent;
import io.cloudevents.jackson.JsonFormat;
import io.reactivex.subscribers.TestSubscriber;
import io.vertx.core.eventbus.EventBus;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.event.DMNRuntimeEventListener;
import org.kie.kogito.Application;
import org.kie.kogito.cloudevents.CloudEventUtils;
import org.kie.kogito.conf.ConfigBean;
import org.kie.kogito.conf.StaticConfigBean;
import org.kie.kogito.decision.DecisionModel;
import org.kie.kogito.decision.DecisionModels;
import org.kie.kogito.dmn.DMNKogito;
import org.kie.kogito.dmn.DmnDecisionModel;
import org.kie.kogito.tracing.decision.QuarkusDecisionTracingCollector;
import org.kie.kogito.tracing.decision.QuarkusDecisionTracingListener;
import org.kie.kogito.tracing.decision.QuarkusTraceEventEmitter;
import org.kie.kogito.tracing.decision.event.evaluate.EvaluateEvent;
import org.kie.kogito.tracing.decision.event.trace.TraceEvent;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.reactivestreams.Subscriber;

public class QuarkusDecisionTracingTest {
    public static final String TEST_MODEL_NAMESPACE = "https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF";
    public static final String TEST_MODEL_NAME = "Traffic Violation";
    private static final Map<String, Object> TEST_CONTEXT_VARIABLES = new HashMap<String, Object>(){
        {
            this.put("Driver", new HashMap<String, Object>(){
                {
                    this.put("Age", 25);
                    this.put("Points", 10);
                }
            });
            this.put("Violation", new HashMap<String, Object>(){
                {
                    this.put("Type", "speed");
                    this.put("Actual Speed", 105);
                    this.put("Speed Limit", 100);
                }
            });
        }
    };
    private static final String TEST_EXECUTION_ID = "7c50581e-6e5b-407b-91d6-2ffb1d47ebc0";
    private static final String TEST_RESOURCE = "/Traffic Violation.dmn";
    private static final String TEST_SERVICE_URL = "localhost:8080";
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)JsonFormat.getCloudEventJacksonModule());

    @Test
    void testAsyncListenerAndCollectorWithRealEventsIsWorking() throws IOException {
        DMNRuntime runtime = this.buildDMNRuntime();
        DecisionModel model = this.buildDecisionModel(runtime);
        List<EvaluateEvent> events = this.testListener(true, runtime, model);
        this.testCollector(events, model);
    }

    @Test
    void testSyncListenerAndCollectorWithRealEventsIsWorking() throws IOException {
        DMNRuntime runtime = this.buildDMNRuntime();
        DecisionModel model = this.buildDecisionModel(runtime);
        List<EvaluateEvent> events = this.testListener(false, runtime, model);
        this.testCollector(events, model);
    }

    private DMNRuntime buildDMNRuntime() {
        return DMNKogito.createGenericDMNRuntime((Reader[])new Reader[]{new InputStreamReader(QuarkusDecisionTracingTest.class.getResourceAsStream(TEST_RESOURCE))});
    }

    private DecisionModel buildDecisionModel(DMNRuntime runtime) {
        return new DmnDecisionModel(runtime, TEST_MODEL_NAMESPACE, TEST_MODEL_NAME, () -> TEST_EXECUTION_ID);
    }

    private List<EvaluateEvent> testListener(boolean asyncEnabled, DMNRuntime runtime, DecisionModel model) {
        EventBus mockedEventBus = (EventBus)Mockito.mock(EventBus.class);
        QuarkusDecisionTracingCollector mockedCollector = (QuarkusDecisionTracingCollector)Mockito.mock(QuarkusDecisionTracingCollector.class);
        QuarkusDecisionTracingListener listener = new QuarkusDecisionTracingListener(mockedEventBus, mockedCollector, asyncEnabled);
        runtime.addListener((DMNRuntimeEventListener)listener);
        DMNContext context = model.newContext(TEST_CONTEXT_VARIABLES);
        model.evaluateAll(context);
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(EvaluateEvent.class);
        if (asyncEnabled) {
            ((EventBus)Mockito.verify((Object)mockedEventBus, (VerificationMode)Mockito.times((int)14))).send((String)ArgumentMatchers.eq((Object)"kogito-tracing-decision_EvaluateEvent"), eventCaptor.capture());
            ((QuarkusDecisionTracingCollector)Mockito.verify((Object)mockedCollector, (VerificationMode)Mockito.never())).onEvent((EvaluateEvent)ArgumentMatchers.any());
        } else {
            ((EventBus)Mockito.verify((Object)mockedEventBus, (VerificationMode)Mockito.never())).send((String)ArgumentMatchers.eq((Object)"kogito-tracing-decision_EvaluateEvent"), ArgumentMatchers.any());
            ((QuarkusDecisionTracingCollector)Mockito.verify((Object)mockedCollector, (VerificationMode)Mockito.times((int)14))).onEvent((EvaluateEvent)eventCaptor.capture());
        }
        return eventCaptor.getAllValues();
    }

    private void testCollector(List<EvaluateEvent> events, DecisionModel model) throws IOException {
        TestSubscriber subscriber = new TestSubscriber();
        DecisionModels mockedDecisionModels = (DecisionModels)Mockito.mock(DecisionModels.class);
        Mockito.when((Object)mockedDecisionModels.getDecisionModel(TEST_MODEL_NAMESPACE, TEST_MODEL_NAME)).thenReturn((Object)model);
        Application mockedApplication = (Application)Mockito.mock(Application.class);
        Mockito.when((Object)mockedApplication.get((Class)ArgumentMatchers.any())).thenReturn((Object)mockedDecisionModels);
        StaticConfigBean configBean = new StaticConfigBean(TEST_SERVICE_URL, true, null);
        QuarkusTraceEventEmitter eventEmitter = new QuarkusTraceEventEmitter();
        QuarkusDecisionTracingCollector collector = new QuarkusDecisionTracingCollector(eventEmitter, (ConfigBean)configBean, mockedApplication);
        eventEmitter.getEventPublisher().subscribe((Subscriber)subscriber);
        events.forEach(arg_0 -> ((QuarkusDecisionTracingCollector)collector).onEvent(arg_0));
        subscriber.assertValueCount(1);
        CloudEvent cloudEvent = (CloudEvent)CloudEventUtils.decode((String)((String)subscriber.values().get(0))).orElseThrow(() -> new IllegalStateException("Can't decode CloudEvent"));
        Assertions.assertEquals((Object)TEST_EXECUTION_ID, (Object)cloudEvent.getId());
        Assertions.assertNotNull((Object)cloudEvent.getData());
        TraceEvent traceEvent = (TraceEvent)MAPPER.readValue(cloudEvent.getData(), TraceEvent.class);
        Assertions.assertNotNull((Object)traceEvent);
        Assertions.assertEquals((Object)TEST_SERVICE_URL, (Object)traceEvent.getHeader().getResourceId().getServiceUrl());
    }
}

