/*
 * Decompiled with CFR 0.152.
 */
package org.acme.travel;

import io.quarkus.test.junit.QuarkusTest;
import java.util.Date;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.acme.travels.Address;
import org.acme.travels.Hotel;
import org.acme.travels.Traveller;
import org.acme.travels.Trip;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Model;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;

@Disabled(value="Disabled by default as it requires inifinispan and kafka")
@QuarkusTest
public class BookHotelTest {
    @Inject
    @Named(value="hotelBooking")
    Process<? extends Model> bookHotelProcess;

    @Test
    public void testBookingHotel() {
        Assertions.assertNotNull(this.bookHotelProcess);
        Model m = (Model)this.bookHotelProcess.createModel();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("traveller", new Traveller("John", "Doe", "john.doe@example.com", "American", new Address("main street", "Boston", "10005", "US")));
        parameters.put("trip", new Trip("New York", "US", new Date(), new Date()));
        m.fromMap(parameters);
        ProcessInstance processInstance = this.bookHotelProcess.createInstance(m);
        processInstance.start();
        Assertions.assertEquals((int)2, (int)processInstance.status());
        Model result = (Model)processInstance.variables();
        Assertions.assertEquals((int)3, (int)result.toMap().size());
        Hotel hotel = (Hotel)result.toMap().get("hotel");
        Assertions.assertNotNull((Object)hotel);
        Assertions.assertEquals((Object)"Perfect hotel", (Object)hotel.getName());
        Assertions.assertEquals((Object)"XX-012345", (Object)hotel.getBookingNumber());
        Assertions.assertEquals((Object)"09876543", (Object)hotel.getPhone());
    }
}

