/*
 * Decompiled with CFR 0.152.
 */
package org.acme.travel;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.acme.travels.Address;
import org.acme.travels.Flight;
import org.acme.travels.Hotel;
import org.acme.travels.Traveller;
import org.acme.travels.Trip;
import org.acme.travels.VisaApplication;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Model;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.testcontainers.quarkus.InfinispanQuarkusTestResource;
import org.kie.kogito.testcontainers.quarkus.KafkaQuarkusTestResource;

@QuarkusTest
@QuarkusTestResource.List(value={@QuarkusTestResource(value=InfinispanQuarkusTestResource.class), @QuarkusTestResource(value=KafkaQuarkusTestResource.class)})
public class TravelIT {
    private static final Traveller TRAVELLER_FROM_POLAND = new Traveller("Jan", "Kowalski", "jan.kowalski@example.com", "Polish", new Address("polna", "Krakow", "32000", "Poland"));
    private static final Trip TRIP_TO_POLAND = new Trip("Another City", "Poland", new Date(), new Date());
    private static final Trip TRIP_TO_US = new Trip("New York", "US", new Date(), new Date());
    private static final String STEP_CONFIRM_TRAVEL = "ConfirmTravel";
    private static final String STEP_VISA_APPLICATION = "VisaApplication";
    @Inject
    @Named(value="travels")
    Process<? extends Model> travelsProcess;
    private ProcessInstance<?> processInstance;

    @BeforeEach
    public void cleanUp() {
        this.travelsProcess.instances().values(ProcessInstanceReadMode.MUTABLE).forEach(pi -> pi.abort());
        this.processInstance = null;
    }

    @Test
    public void testTravelNoVisaRequired() {
        this.whenNewTravel(TRAVELLER_FROM_POLAND, TRIP_TO_POLAND);
        this.thenProcessIsActive();
        this.thenHotelAndFlightAreChosen();
        this.whenConfirmTravel();
        this.thenProcessIsCompleted();
    }

    @Test
    public void testTravelVisaRequired() {
        this.whenNewTravel(TRAVELLER_FROM_POLAND, TRIP_TO_US);
        this.thenProcessIsActive();
        this.whenAddVisaApplication();
        this.thenProcessIsActive();
    }

    private void whenNewTravel(Traveller traveller, Trip trip) {
        Model m = (Model)this.travelsProcess.createModel();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("traveller", traveller);
        parameters.put("trip", trip);
        m.fromMap(parameters);
        this.processInstance = this.travelsProcess.createInstance(m);
        this.processInstance.start();
    }

    private void whenConfirmTravel() {
        WorkItem workItem = this.thenNextStepIs(STEP_CONFIRM_TRAVEL);
        this.processInstance.completeWorkItem(workItem.getId(), null, new Policy[0]);
    }

    private void whenAddVisaApplication() {
        HashMap<String, VisaApplication> results = new HashMap<String, VisaApplication>();
        results.put("visaApplication", new VisaApplication("Jan", "Kowalski", "New York", "US", 10, "XXX098765"));
        WorkItem workItem = this.thenNextStepIs(STEP_VISA_APPLICATION);
        this.processInstance.completeWorkItem(workItem.getId(), results, new Policy[0]);
    }

    private WorkItem thenNextStepIs(String expected) {
        List workItems = this.processInstance.workItems(new Policy[0]);
        Assertions.assertEquals((int)1, (int)workItems.size());
        WorkItem next = (WorkItem)workItems.get(0);
        Assertions.assertEquals((Object)expected, (Object)next.getName());
        return next;
    }

    private void thenProcessIsActive() {
        Assertions.assertEquals((int)1, (int)this.processInstance.status());
    }

    private void thenProcessIsCompleted() {
        Assertions.assertEquals((int)2, (int)this.processInstance.status());
    }

    private void thenHotelAndFlightAreChosen() {
        Model result = (Model)this.processInstance.variables();
        Assertions.assertEquals((int)5, (int)result.toMap().size());
        Hotel hotel = (Hotel)result.toMap().get("hotel");
        Assertions.assertNotNull((Object)hotel);
        Assertions.assertEquals((Object)"Perfect hotel", (Object)hotel.getName());
        Assertions.assertEquals((Object)"XX-012345", (Object)hotel.getBookingNumber());
        Assertions.assertEquals((Object)"09876543", (Object)hotel.getPhone());
        Flight flight = (Flight)result.toMap().get("flight");
        Assertions.assertNotNull((Object)flight);
        Assertions.assertEquals((Object)"MX555", (Object)flight.getFlightNumber());
        Assertions.assertNotNull((Object)flight.getArrival());
        Assertions.assertNotNull((Object)flight.getDeparture());
    }
}

