/*
 * Decompiled with CFR 0.152.
 */
package org.acme.travel;

import io.quarkus.test.junit.QuarkusTest;
import java.util.Date;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.acme.travels.Address;
import org.acme.travels.Flight;
import org.acme.travels.Traveller;
import org.acme.travels.Trip;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Model;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;

@QuarkusTest
public class BookFlightIT {
    @Inject
    @Named(value="flightBooking")
    Process<? extends Model> bookFlightProcess;

    @Test
    public void testBookingFlight() {
        Assertions.assertNotNull(this.bookFlightProcess);
        Model m = (Model)this.bookFlightProcess.createModel();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("traveller", new Traveller("John", "Doe", "john.doe@example.com", "American", new Address("main street", "Boston", "10005", "US")));
        parameters.put("trip", new Trip("New York", "US", new Date(), new Date()));
        m.fromMap(parameters);
        ProcessInstance processInstance = this.bookFlightProcess.createInstance(m);
        processInstance.start();
        Assertions.assertEquals((int)2, (int)processInstance.status());
        Model result = (Model)processInstance.variables();
        Assertions.assertEquals((int)3, (int)result.toMap().size());
        Flight flight = (Flight)result.toMap().get("flight");
        Assertions.assertNotNull((Object)flight);
        Assertions.assertEquals((Object)"MX555", (Object)flight.getFlightNumber());
        Assertions.assertNotNull((Object)flight.getArrival());
        Assertions.assertNotNull((Object)flight.getDeparture());
    }
}

