/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.ChainAuth;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.authentication.CredentialValidationException;
import io.vertx.ext.auth.authentication.Credentials;
import java.util.ArrayList;
import java.util.List;

public class ChainAuthImpl
implements ChainAuth {
    private final List<AuthenticationProvider> providers = new ArrayList<AuthenticationProvider>();
    private final boolean all;

    public ChainAuthImpl(boolean all) {
        this.all = all;
    }

    @Override
    public ChainAuth add(AuthenticationProvider other) {
        this.providers.add(other);
        return this;
    }

    @Override
    public void authenticate(Credentials credentials, Handler<AsyncResult<User>> resultHandler) {
        try {
            credentials.checkValid(null);
            this.authenticate(credentials.toJson(), resultHandler);
        }
        catch (CredentialValidationException e) {
            resultHandler.handle(Future.failedFuture(e));
        }
    }

    @Override
    public void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> resultHandler) {
        if (this.providers.size() == 0) {
            resultHandler.handle(Future.failedFuture("No providers in the auth chain."));
        } else {
            this.iterate(0, authInfo, resultHandler, null);
        }
    }

    private void iterate(int idx, JsonObject authInfo, Handler<AsyncResult<User>> resultHandler, User previousUser) {
        if (idx >= this.providers.size()) {
            if (!this.all) {
                resultHandler.handle(Future.failedFuture("No more providers in the auth chain."));
            } else {
                resultHandler.handle(Future.succeededFuture(previousUser));
            }
            return;
        }
        this.providers.get(idx).authenticate(authInfo, (AsyncResult<User> res) -> {
            if (res.succeeded()) {
                if (!this.all) {
                    resultHandler.handle((AsyncResult<User>)res);
                } else {
                    this.iterate(idx + 1, authInfo, resultHandler, previousUser == null ? (User)res.result() : User.create(previousUser.principal().mergeIn(((User)res.result()).principal())));
                }
            } else if (!this.all) {
                this.iterate(idx + 1, authInfo, resultHandler, null);
            } else {
                resultHandler.handle((AsyncResult<User>)res);
            }
        });
    }
}

