/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.common.handlers;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.query.QueryFilterFactory;
import org.kie.kogito.persistence.api.query.SortDirection;
import org.kie.kogito.trusty.service.common.handlers.ExplainabilityResultsManager;
import org.kie.kogito.trusty.storage.api.model.CounterfactualExplainabilityResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class CounterfactualSlidingWindowExplainabilityResultsManager
implements ExplainabilityResultsManager<CounterfactualExplainabilityResult> {
    private static final Logger LOG = LoggerFactory.getLogger(CounterfactualSlidingWindowExplainabilityResultsManager.class);
    private final int lengthOfWindow;

    public CounterfactualSlidingWindowExplainabilityResultsManager() {
    }

    public CounterfactualSlidingWindowExplainabilityResultsManager(@ConfigProperty(name="trusty.explainability.counterfactual.results.window.length", defaultValue="10") int lengthOfWindow) {
        if (lengthOfWindow < 1) {
            throw new IllegalArgumentException("The length of the result window must be at least one.");
        }
        this.lengthOfWindow = lengthOfWindow;
    }

    @Override
    public void purge(String counterfactualId, Storage<String, CounterfactualExplainabilityResult> storage) {
        ArrayList<CounterfactualExplainabilityResult> results = new ArrayList<CounterfactualExplainabilityResult>(storage.query().sort(List.of(QueryFilterFactory.orderBy("sequenceId", SortDirection.ASC))).filter(List.of(QueryFilterFactory.equalTo("counterfactualId", counterfactualId))).execute());
        int overflow = results.size() - this.lengthOfWindow;
        while (overflow > 0) {
            CounterfactualExplainabilityResult result = (CounterfactualExplainabilityResult)results.get(--overflow);
            String solutionId = result.getSolutionId();
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("Counterfactual results overflow window with size %d by %d.", this.lengthOfWindow, overflow));
                LOG.info(String.format("Removing stale solution %s, sequence %d", solutionId, result.getSequenceId()));
            }
            storage.remove(solutionId);
        }
    }
}

