/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.storage.infinispan;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.MessageMarshaller;
import org.kie.kogito.trusty.storage.infinispan.CounterfactualExplainabilityRequestMarshaller;
import org.kie.kogito.trusty.storage.infinispan.CounterfactualExplainabilityResultMarshaller;
import org.kie.kogito.trusty.storage.infinispan.DMNModelWithMetadataMarshaller;
import org.kie.kogito.trusty.storage.infinispan.DecisionMarshaller;
import org.kie.kogito.trusty.storage.infinispan.LIMEExplainabilityResultMarshaller;

@ApplicationScoped
public class ProtostreamProducer {
    @Inject
    ObjectMapper mapper;

    @Produces
    FileDescriptorSource kogitoTypesDescriptor() throws IOException {
        FileDescriptorSource source = new FileDescriptorSource();
        source.addProtoFile("decision.proto", Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/decision.proto"));
        return source;
    }

    @Produces
    MessageMarshaller decisionMarshaller() {
        return new DecisionMarshaller(this.mapper);
    }

    @Produces
    MessageMarshaller explainabilityResultMarshaller() {
        return new LIMEExplainabilityResultMarshaller(this.mapper);
    }

    @Produces
    MessageMarshaller dmnModelMarshaller() {
        return new DMNModelWithMetadataMarshaller(this.mapper);
    }

    @Produces
    MessageMarshaller counterfactualMarshaller() {
        return new CounterfactualExplainabilityRequestMarshaller(this.mapper);
    }

    @Produces
    MessageMarshaller counterfactualResultMarshaller() {
        return new CounterfactualExplainabilityResultMarshaller(this.mapper);
    }
}

